server {
    server_name www.trendsistem.com trendsistem.com;

    if ($host = www.trendsistem.com) {
        return 301 https://trendsistem.com$request_uri;
    } # managed by Certbot

    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection keep-alive;
    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;

    root /apps/trendsistem.com/public_html;
    index index.html index.php index.nginx-debian.html;


    listen [::]:443 ssl; # managed by Certbot
    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/www.trendsistem.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/www.trendsistem.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot


}
server {
    if ($host = trendsistem.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = www.trendsistem.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    server_name www.trendsistem.com trendsistem.com;



    listen 80;
    listen [::]:80;
    return 404; # managed by Certbot




}