server {

    server_name kurulum.dinamikotomasyon.com kurulum.dinamikup.com;

    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_read_timeout 86400;

    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-Forwarded-Host $host;
    proxy_set_header X-Forwarded-Port $server_port;

    root /apps/kurulum.dinamikup.com;
    index index.html index.php;

    location / {


        try_files $uri $uri/ /index.php$is_args$args;


    }

    location ~ \.php$ {
        fastcgi_split_path_info ^(.+\.php)(/.+)$;
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        include fastcgi.conf;
    }

    error_log  /var/log/nginx/kurulum.dinamikup.com-error.log error;



    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/kurulum.dinamikotomasyon.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/kurulum.dinamikotomasyon.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot


}
server {
    if ($host = kurulum.dinamikup.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = kurulum.dinamikotomasyon.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot



    server_name kurulum.dinamikotomasyon.com kurulum.dinamikup.com;



    listen 80;
    return 404; # managed by Certbot




}