server {

    server_name operon.dinamikotomasyon.com;

    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_read_timeout 86400;

    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-Forwarded-Host $host;
    proxy_set_header X-Forwarded-Port $server_port;


    location / {
        if ($host = operon.dinamikotomasyon.com) {
	    proxy_pass http://127.0.0.1:10510$request_uri;
        }

    }

    error_log  /var/log/nginx/operon.dinamikotomasyon.com-error.log error;


    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/operon.dinamikotomasyon.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/operon.dinamikotomasyon.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot

}
server {
    if ($host = operon.dinamikotomasyon.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot



    server_name operon.dinamikotomasyon.com;


    listen 80;
    return 404; # managed by Certbot


}