server {
    server_name api.connectorabi.com www.connectorabi.com kernel.connectorabi.com connectorabi.com;

    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_read_timeout 86400;

    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;

    location / {
        if ($host = kernel.connectorabi.com) {
            proxy_pass http://127.0.0.1:4600$request_uri;
        }
    }

    root /apps/connectorabi.com/public_html;
    index index.html index.htm index.nginx-debian.html;


    listen [::]:443 ssl; # managed by Certbot
    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/www.connectorabi.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/www.connectorabi.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot




}
server {
    if ($host = connectorabi.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = api.connectorabi.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = kernel.connectorabi.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = www.connectorabi.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    server_name api.connectorabi.com www.connectorabi.com kernel.connectorabi.com connectorabi.com;


    listen 80;
    listen [::]:80;
    return 404; # managed by Certbot








}