server {

    server_name www.arslantasbeton.com arslantasbeton.com;

    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_read_timeout 86400;

    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-Forwarded-Host $host;
    proxy_set_header X-Forwarded-Port $server_port;

    root /apps/arslantasbeton.com/public_html;
    index index.html index.php;

    location / {


        try_files $uri $uri/ /index.php$is_args$args;


    }

    location ~ \.php$ {
        fastcgi_split_path_info ^(.+\.php)(/.+)$;
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        include fastcgi.conf;
    }

    error_log  /var/log/nginx/arslantasbeton.com-error.log error;

    listen 443 ssl; # managed by Certbot
    listen [::]:443 ssl ipv6only=on; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/www.arslantasbeton.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/www.arslantasbeton.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot


}
server {
    if ($host = arslantasbeton.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    if ($host = www.arslantasbeton.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot



    server_name www.arslantasbeton.com arslantasbeton.com;



    listen 80;
    listen [::]:80;
    return 404; # managed by Certbot




}