<?php

/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Yuki
 */
use LottaFramework\Facades\Css;
use LottaFramework\Facades\CZ;
use LottaFramework\Icons\IconsManager;
use LottaFramework\Utils;
if ( !function_exists( 'yuki_get_html_attributes' ) ) {
    function yuki_get_html_attributes(  $attr = null  ) {
        if ( CZ::checked( 'yuki_save_color_scheme' ) ) {
            $attrs = [
                'data-save-color-scheme' => 'yes',
                'data-yuki-theme'        => $_COOKIE['yuki-color-mode'] ?? CZ::get( 'yuki_default_color_scheme' ),
            ];
        } else {
            $attrs = [
                'data-save-color-scheme' => 'no',
                'data-yuki-theme'        => CZ::get( 'yuki_default_color_scheme' ),
            ];
        }
        $attrs = apply_filters( 'yuki_html_attributes', $attrs );
        if ( $attr === null ) {
            return $attrs;
        }
        return $attrs[$attr] ?? null;
    }

}
if ( !function_exists( 'yuki_html_attributes' ) ) {
    /**
     * Output html attributes
     */
    function yuki_html_attributes() {
        Utils::print_attribute_string( yuki_get_html_attributes() );
    }

}
if ( !function_exists( 'yuki_image_size_options' ) ) {
    /**
     * @param bool $add_disable
     * @param array $allowed
     * @param bool $show_dimension
     *
     * @return array
     */
    function yuki_image_size_options(  $add_disable = true, array $allowed = [], $show_dimension = true  ) {
        global $_wp_additional_image_sizes;
        $choices = [];
        if ( true === $add_disable ) {
            $choices['disable'] = 'No Image';
        }
        $choices['thumbnail'] = 'Thumbnail';
        $choices['medium'] = 'Medium';
        $choices['large'] = 'Large';
        $choices['full'] = 'Full (original)';
        if ( true === $show_dimension ) {
            foreach ( ['thumbnail', 'medium', 'large'] as $_size ) {
                $choices[$_size] = $choices[$_size] . ' (' . get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
            }
        }
        if ( !empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {
            foreach ( $_wp_additional_image_sizes as $key => $size ) {
                $choices[$key] = $key;
                if ( true === $show_dimension ) {
                    $choices[$key] .= ' (' . $size['width'] . 'x' . $size['height'] . ')';
                }
            }
        }
        if ( !empty( $allowed ) ) {
            foreach ( $choices as $key => $value ) {
                if ( !in_array( $key, $allowed, true ) ) {
                    unset($choices[$key]);
                }
            }
        }
        return $choices;
    }

}
if ( !function_exists( 'yuki_image' ) ) {
    /**
     * Get image file
     *
     * @param $name
     *
     * @return mixed|string
     */
    function yuki_image(  $name  ) {
        $svgs = [
            'none'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M9.943 17.415h-0.065l-2.095-3.199-2.559-3.777h-1.984v11.025h2.191v-6.944h0.095l1.819 2.784 2.793 4.16h1.996v-11.025h-2.191v6.977zM12.904 22.135h1.615l4.049-12.271h-1.633l-4.031 12.271zM24.92 10.439h-2.24l-3.874 11.025h2.336l0.72-2.273h3.841l0.672 2.273h2.384l-3.84-11.025zM22.455 17.352l0.447-1.456 0.85-2.864h0.063l0.866 2.913 0.431 1.408h-2.656z"></path></svg>',
            'divider-1'               => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path d="M9,17.2l5.1-10.9L15,6.8L9.9,17.6L9,17.2z"/></svg>',
            'divider-2'               => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path d="M8.9,11.5h6.3v1H8.9V11.5z"/></svg>',
            'divider-3'               => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 20 20"><path d="M7.8 10c0 1.215 0.986 2.2 2.201 2.2s2.199-0.986 2.199-2.2c0-1.215-0.984-2.199-2.199-2.199s-2.201 0.984-2.201 2.199z"></path></svg>',
            'text-left'               => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M3.328 14.4c-1.056 0-1.984-0.8-1.984-1.728s0.928-1.728 1.984-1.728h24c1.088 0 2.016 0.8 2.016 1.728s-0.928 1.728-2.016 1.728h-24zM3.328 21.056c-1.056 0-1.984-0.8-1.984-1.728s0.928-1.728 1.984-1.728h20c1.088 0 2.016 0.8 2.016 1.728s-0.928 1.728-2.016 1.728h-20zM3.328 27.744c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76h-25.344zM3.328 7.744c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h17.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76h-17.344z"></path></svg>',
            'text-center'             => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M6.016 14.4c-1.088 0-2.016-0.8-2.016-1.728s0.928-1.728 2.016-1.728h19.84c1.216 0 2.016 0.8 2.016 1.728s-0.928 1.728-2.016 1.728h-19.84zM8.672 21.056c-1.056 0-2.016-0.8-2.016-1.728s0.96-1.728 2.016-1.728h14.656c1.088 0 2.016 0.8 2.016 1.728s-0.928 1.728-2.016 1.728h-14.656zM3.328 27.744c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76h-25.344zM11.456 7.744c-1.184 0-2.112-0.8-2.112-1.76s0.928-1.728 2.112-1.728h9.088c1.184 0 2.112 0.8 2.112 1.728s-0.928 1.76-2.112 1.76h-9.088z"></path></svg>',
            'text-right'              => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M28.672 14.4h-24c-1.056 0-2.016-0.8-2.016-1.728s0.96-1.728 2.016-1.728h24c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.728-1.984 1.728zM28.672 21.056h-20c-1.056 0-2.016-0.8-2.016-1.728s0.96-1.728 2.016-1.728h20c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.728-1.984 1.728zM28.672 27.744h-25.344c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76zM28.672 7.744h-17.344c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h17.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76z"></path></svg>',
            'text-justify'            => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M3.328 27.744c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76h-25.344zM3.328 21.056c-1.056 0-1.984-0.8-1.984-1.728s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.728-1.984 1.728h-25.344zM3.328 14.4c-1.056 0-1.984-0.8-1.984-1.728s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.728-1.984 1.728h-25.344zM3.328 7.744c-1.056 0-1.984-0.8-1.984-1.76s0.928-1.728 1.984-1.728h25.344c1.056 0 1.984 0.8 1.984 1.728s-0.928 1.76-1.984 1.76h-25.344z"></path></svg>',
            'justify-space-between-v' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M30.656 29.344c0.736 0 1.344 0.576 1.344 1.312 0 0.704-0.512 1.28-1.184 1.344h-29.472c-0.736 0-1.344-0.608-1.344-1.344 0-0.672 0.512-1.248 1.184-1.312h29.472zM24.8 21.344c1.024 0 1.856 0.832 1.856 1.856v3.456h-21.312v-3.456c0-1.024 0.832-1.856 1.856-1.856h17.6zM26.656 5.344v3.456c0 1.024-0.832 1.856-1.856 1.856h-17.6c-1.024 0-1.856-0.832-1.856-1.856v-3.456h21.312zM30.656 0c0.736 0 1.344 0.608 1.344 1.344 0 0.672-0.512 1.248-1.184 1.312h-29.472c-0.736 0-1.344-0.576-1.344-1.312 0-0.704 0.512-1.28 1.184-1.344h29.472z"></path></svg>',
            'justify-space-around-v'  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M30.656 29.344c0.736 0 1.344 0.576 1.344 1.312 0 0.704-0.512 1.28-1.184 1.344h-29.472c-0.736 0-1.344-0.608-1.344-1.344 0-0.672 0.512-1.248 1.184-1.312h29.472zM24.8 17.344c1.024 0 1.856 0.832 1.856 1.856v1.6c0 1.024-0.832 1.856-1.856 1.856h-17.6c-1.024 0-1.856-0.832-1.856-1.856v-1.6c0-1.024 0.832-1.856 1.856-1.856h17.6zM24.8 9.344c1.024 0 1.856 0.832 1.856 1.856v1.6c0 1.024-0.832 1.856-1.856 1.856h-17.6c-1.024 0-1.856-0.832-1.856-1.856v-1.6c0-1.024 0.832-1.856 1.856-1.856h17.6zM30.656 0c0.736 0 1.344 0.608 1.344 1.344 0 0.672-0.512 1.248-1.184 1.312h-29.472c-0.736 0-1.344-0.576-1.344-1.312 0-0.704 0.512-1.28 1.184-1.344h29.472z"></path></svg>',
            'justify-start-v'         => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M24.928 20c0.96 0 1.728 0.768 1.728 1.728v1.856c0 0.96-0.768 1.76-1.728 1.76h-17.856c-0.96 0-1.728-0.8-1.728-1.76v-1.856c0-0.96 0.768-1.728 1.728-1.728h17.856zM24.928 12c0.96 0 1.728 0.768 1.728 1.728v1.856c0 0.96-0.768 1.76-1.728 1.76h-17.856c-0.96 0-1.728-0.8-1.728-1.76v-1.856c0-0.96 0.768-1.728 1.728-1.728h17.856zM30.656 6.656c0.736 0 1.344 0.608 1.344 1.344 0 0.672-0.512 1.248-1.184 1.312l-0.16 0.032h-29.312c-0.736 0-1.344-0.608-1.344-1.344 0-0.672 0.512-1.248 1.184-1.312l0.16-0.032h29.312z"></path></svg>',
            'justify-center-v'        => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M24.928 20c0.96 0 1.728 0.768 1.728 1.728v1.856c0 0.96-0.768 1.76-1.728 1.76h-17.856c-0.96 0-1.728-0.8-1.728-1.76v-1.856c0-0.96 0.768-1.728 1.728-1.728h17.856zM30.656 14.656c0.736 0 1.344 0.608 1.344 1.344 0 0.672-0.512 1.248-1.184 1.312l-0.16 0.032h-29.312c-0.736 0-1.344-0.608-1.344-1.344 0-0.672 0.512-1.248 1.184-1.312l0.16-0.032h29.312zM24.928 6.656c0.96 0 1.728 0.768 1.728 1.728v1.888c0 0.96-0.768 1.728-1.728 1.728h-17.856c-0.96 0-1.728-0.768-1.728-1.728v-1.888c0-0.96 0.768-1.728 1.728-1.728h17.856z"></path></svg>',
            'justify-end-v'           => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M30.656 22.656c0.736 0 1.344 0.608 1.344 1.344 0 0.672-0.512 1.248-1.184 1.312l-0.16 0.032h-29.312c-0.736 0-1.344-0.608-1.344-1.344 0-0.672 0.512-1.248 1.184-1.312l0.16-0.032h29.312zM24.928 14.656c0.96 0 1.728 0.768 1.728 1.728v1.888c0 0.96-0.768 1.728-1.728 1.728h-17.856c-0.96 0-1.728-0.768-1.728-1.728v-1.888c0-0.96 0.768-1.728 1.728-1.728h17.856zM24.928 6.656c0.96 0 1.728 0.768 1.728 1.728v1.888c0 0.96-0.768 1.728-1.728 1.728h-17.856c-0.96 0-1.728-0.768-1.728-1.728v-1.888c0-0.96 0.768-1.728 1.728-1.728h17.856z"></path></svg>',
            'justify-space-between-h' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M1.344 0c0.672 0 1.248 0.512 1.312 1.184v29.472c0 0.736-0.576 1.344-1.312 1.344-0.704 0-1.248-0.512-1.344-1.184v-29.472c0-0.736 0.608-1.344 1.344-1.344zM30.656 0c0.704 0 1.28 0.512 1.344 1.184v29.472c0 0.736-0.608 1.344-1.344 1.344-0.672 0-1.248-0.512-1.312-1.184v-29.472c0-0.736 0.576-1.344 1.312-1.344zM8.8 5.344c1.024 0 1.856 0.832 1.856 1.856v17.6c0 1.024-0.832 1.856-1.856 1.856h-3.456v-21.312h3.456zM26.656 5.344v21.312h-3.456c-1.024 0-1.856-0.832-1.856-1.856v-17.6c0-1.024 0.832-1.856 1.856-1.856h3.456z"></path></svg>',
            'justify-space-around-h'  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M30.656 0c0.704 0 1.28 0.512 1.344 1.184v29.472c0 0.736-0.608 1.344-1.344 1.344-0.672 0-1.248-0.512-1.312-1.184v-29.472c0-0.736 0.576-1.344 1.312-1.344zM1.344 0c0.672 0 1.248 0.512 1.312 1.184v29.472c0 0.736-0.576 1.344-1.312 1.344-0.704 0-1.248-0.512-1.344-1.184v-29.472c0-0.736 0.608-1.344 1.344-1.344zM20.8 5.344c1.024 0 1.856 0.832 1.856 1.856v17.6c0 1.024-0.832 1.856-1.856 1.856h-1.6c-1.024 0-1.856-0.832-1.856-1.856v-17.6c0-1.024 0.832-1.856 1.856-1.856h1.6zM12.8 5.344c1.024 0 1.856 0.832 1.856 1.856v17.6c0 1.024-0.832 1.856-1.856 1.856h-1.6c-1.024 0-1.856-0.832-1.856-1.856v-17.6c0-1.024 0.832-1.856 1.856-1.856h1.6z"></path></svg>',
            'justify-start-h'         => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M8 0c0.672 0 1.248 0.512 1.312 1.184l0.032 0.16v29.312c0 0.736-0.608 1.344-1.344 1.344-0.672 0-1.248-0.512-1.312-1.184l-0.032-0.16v-29.312c0-0.736 0.608-1.344 1.344-1.344zM15.616 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.888c-0.96 0-1.728-0.768-1.728-1.728v-17.856c0-0.96 0.768-1.728 1.728-1.728h1.888zM23.616 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.888c-0.96 0-1.728-0.768-1.728-1.728v-17.856c0-0.96 0.768-1.728 1.728-1.728h1.888z"></path></svg>',
            'justify-center-h'        => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M16 0c0.672 0 1.248 0.512 1.312 1.184l0.032 0.16v29.312c0 0.736-0.608 1.344-1.344 1.344-0.672 0-1.248-0.512-1.312-1.184l-0.032-0.16v-29.312c0-0.736 0.608-1.344 1.344-1.344zM23.616 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.888c-0.96 0-1.728-0.768-1.728-1.728v-17.856c0-0.96 0.768-1.728 1.728-1.728h1.888zM10.272 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.856c-0.96 0-1.76-0.768-1.76-1.728v-17.856c0-0.96 0.8-1.728 1.76-1.728h1.856z"></path></svg>',
            'justify-end-h'           => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M24 0c0.672 0 1.248 0.512 1.312 1.184l0.032 0.16v29.312c0 0.736-0.608 1.344-1.344 1.344-0.672 0-1.248-0.512-1.312-1.184l-0.032-0.16v-29.312c0-0.736 0.608-1.344 1.344-1.344zM18.272 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.856c-0.96 0-1.76-0.768-1.76-1.728v-17.856c0-0.96 0.8-1.728 1.76-1.728h1.856zM10.272 5.344c0.96 0 1.728 0.768 1.728 1.728v17.856c0 0.96-0.768 1.728-1.728 1.728h-1.856c-0.96 0-1.76-0.768-1.76-1.728v-17.856c0-0.96 0.8-1.728 1.76-1.728h1.856z"></path></svg>',
            'top-top-1'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z"/></svg>',
            'top-top-2'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M34.9 289.5l-22.2-22.2c-9.4-9.4-9.4-24.6 0-33.9L207 39c9.4-9.4 24.6-9.4 33.9 0l194.3 194.3c9.4 9.4 9.4 24.6 0 33.9L413 289.4c-9.5 9.5-25 9.3-34.3-.4L264 168.6V456c0 13.3-10.7 24-24 24h-32c-13.3 0-24-10.7-24-24V168.6L69.2 289.1c-9.3 9.8-24.8 10-34.3.4z"/></svg>',
            'top-top-3'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 320 512"><path d="M9.39 265.4l127.1-128C143.6 131.1 151.8 128 160 128s16.38 3.125 22.63 9.375l127.1 128c9.156 9.156 11.9 22.91 6.943 34.88S300.9 320 287.1 320H32.01c-12.94 0-24.62-7.781-29.58-19.75S.2333 274.5 9.39 265.4z"/></svg>',
            'top-top-4'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M15.36 6.688c0.352-0.352 0.928-0.352 1.28 0l4.416 4.416c0.576 0.544 0.16 1.472-0.608 1.472h-2.72v16.288c-0.096 0.992-0.832 1.792-1.728 1.792h-0.16c-0.896-0.096-1.568-0.96-1.568-1.984v-16.096h-2.72c-0.768 0-1.184-0.928-0.608-1.472l4.416-4.416zM29.344 0.928c0.96 0 1.728 0.768 1.728 1.728s-0.768 1.728-1.728 1.728h-26.688c-0.96 0-1.728-0.768-1.728-1.728s0.768-1.728 1.728-1.728h26.688z"></path></svg>',
            'top-top-5'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M105.6 83.2v86.177a115.52 115.52 0 0 0-22.4-2.176c-47.914 0-83.2 35.072-83.2 92 0 45.314 48.537 57.002 78.784 75.707 12.413 7.735 23.317 16.994 33.253 25.851l.146.131.148.129C129.807 376.338 136 384.236 136 391.2v2.679c-4.952 5.747-8 13.536-8 22.12v64c0 17.673 12.894 32 28.8 32h230.4c15.906 0 28.8-14.327 28.8-32v-64c0-8.584-3.048-16.373-8-22.12V391.2c0-28.688 40-67.137 40-127.2v-21.299c0-62.542-38.658-98.8-91.145-99.94-17.813-12.482-40.785-18.491-62.791-15.985A93.148 93.148 0 0 0 272 118.847V83.2C272 37.765 234.416 0 188.8 0c-45.099 0-83.2 38.101-83.2 83.2zm118.4 0v91.026c14.669-12.837 42.825-14.415 61.05 4.95 19.646-11.227 45.624-1.687 53.625 12.925 39.128-6.524 61.325 10.076 61.325 50.6V264c0 45.491-35.913 77.21-39.676 120H183.571c-2.964-25.239-21.222-42.966-39.596-59.075-12.65-11.275-25.3-21.725-39.875-30.799C80.712 279.645 48 267.994 48 259.2c0-23.375 8.8-44 35.2-44 35.2 0 53.075 26.4 70.4 26.4V83.2c0-18.425 16.5-35.2 35.2-35.2 18.975 0 35.2 16.225 35.2 35.2zM352 424c13.255 0 24 10.745 24 24s-10.745 24-24 24-24-10.745-24-24 10.745-24 24-24z"/></svg>',
            'top-top-6'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M23.371 29.529c0 0 0.335-2.012-1.731-4.469 2.011-5.641 2.29-10.778 2.29-10.778s4.133 0.95 4.133 5.026c-0.001 6.981-4.692 10.221-4.692 10.221zM11.979 27.078c0 0-2.768-8.883-2.768-12.568 0-1.658 0.187-3.133 0.478-4.472h12.61c0.293 1.34 0.481 2.816 0.481 4.473 0 3.629-2.76 12.567-2.76 12.567h-8.041zM15.99 12.069c-1.418 0-2.568 1.15-2.568 2.569 0 1.418 1.15 2.569 2.568 2.569s2.569-1.15 2.569-2.569c0.001-1.419-1.15-2.569-2.569-2.569zM15.438 0.596v-3.498h1v3.409c1.143 0.832 4.236 3.478 5.635 8.575h-12.16c1.352-4.957 4.296-7.574 5.525-8.486zM8.629 29.529c0 0-4.691-3.24-4.691-10.221 0-4.076 4.133-5.026 4.133-5.026s0.279 5.137 2.289 10.778c-2.067 2.458-1.731 4.469-1.731 4.469zM17.691 30.045l-0.838-0.838-0.893 2.793-1.062-2.793-0.726 1.451-1.062-2.625h5.752l-1.171 2.012z"></path></svg>',
            'heading'                 => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M448 448c0 17.69-14.33 32-32 32h-96c-17.67 0-32-14.31-32-32s14.33-32 32-32h16v-144h-224v144H128c17.67 0 32 14.31 32 32s-14.33 32-32 32H32c-17.67 0-32-14.31-32-32s14.33-32 32-32h16v-320H32c-17.67 0-32-14.31-32-32s14.33-32 32-32h96c17.67 0 32 14.31 32 32s-14.33 32-32 32H112v112h224v-112H320c-17.67 0-32-14.31-32-32s14.33-32 32-32h96c17.67 0 32 14.31 32 32s-14.33 32-32 32h-16v320H416C433.7 416 448 430.3 448 448z"/></svg>',
            'text'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M192 32h64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H384l0 352c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-352H288V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H192c-88.4 0-160-71.6-160-160s71.6-160 160-160z"/></svg>',
            'call-to-action'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M30.016 7.328h-28c-1.12 0-2.016 0.896-2.016 2.016v13.312c0 1.12 0.896 2.016 2.016 2.016h28c1.088 0 1.984-0.896 1.984-2.016v-13.312c0-1.12-0.896-2.016-1.984-2.016zM30.656 22.656c0 0.384-0.288 0.672-0.64 0.672h-28c-0.384 0-0.672-0.288-0.672-0.672v-13.312c0-0.384 0.288-0.672 0.672-0.672h28c0.352 0 0.64 0.288 0.64 0.672v13.312zM23.328 11.328c-2.56 0-4.672 2.112-4.672 4.672s2.112 4.672 4.672 4.672 4.672-2.112 4.672-4.672-2.080-4.672-4.672-4.672zM23.328 19.328c-1.824 0-3.328-1.504-3.328-3.328s1.504-3.328 3.328-3.328 3.328 1.504 3.328 3.328-1.472 3.328-3.328 3.328zM15.328 19.328h-10.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h10.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM15.328 15.328h-10.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h10.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM15.328 11.328h-10.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h10.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672z"></path></svg>',
            'featured-image'          => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M3.328 21.344c-0.352 0-0.672-0.32-0.672-0.672v-17.344c0-0.384 0.32-0.672 0.672-0.672h25.344c0.384 0 0.672 0.288 0.672 0.672v17.344c0 0.352-0.288 0.672-0.672 0.672h-25.344zM4 20h24v-16h-24v16zM3.328 25.344c-0.352 0-0.672-0.32-0.672-0.672s0.32-0.672 0.672-0.672h10.688c0.352 0 0.64 0.288 0.64 0.672s-0.288 0.672-0.64 0.672h-10.688zM18.016 25.344c-0.384 0-0.672-0.32-0.672-0.672s0.288-0.672 0.672-0.672h10.656c0.384 0 0.672 0.288 0.672 0.672s-0.288 0.672-0.672 0.672h-10.656zM3.328 29.344c-0.352 0-0.672-0.288-0.672-0.672s0.32-0.672 0.672-0.672h10.688c0.352 0 0.64 0.288 0.64 0.672s-0.288 0.672-0.64 0.672h-10.688zM18.016 29.344c-0.384 0-0.672-0.288-0.672-0.672s0.288-0.672 0.672-0.672h10.656c0.384 0 0.672 0.288 0.672 0.672s-0.288 0.672-0.672 0.672h-10.656zM10.144 14.080l-6.304 7.040c-0.256 0.288-0.672 0.288-0.96 0.064-0.288-0.256-0.288-0.672-0.064-0.96l6.72-7.456c0.224-0.256 0.608-0.288 0.864-0.096l3.968 2.816 5.568-6.976c0.288-0.352 0.8-0.32 1.056 0.032l8.224 11.744c0.192 0.32 0.128 0.736-0.16 0.928-0.32 0.224-0.736 0.128-0.96-0.16l-7.68-10.976-5.376 6.752c-0.224 0.288-0.64 0.352-0.928 0.128l-3.968-2.88zM9.792 8.128c0-0.8-0.608-1.472-1.376-1.472s-1.376 0.672-1.376 1.472 0.64 1.472 1.376 1.472 1.376-0.64 1.376-1.472zM11.136 8.128c0 1.536-1.216 2.816-2.72 2.816s-2.688-1.28-2.688-2.816 1.184-2.784 2.688-2.784 2.72 1.248 2.72 2.784z"></path></svg>',
            'review'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M8.128 23.584c-1.856 0-3.456-1.6-3.456-3.456v-9.344c0-1.856 1.472-3.456 3.456-3.456h15.744c1.856 0 3.456 1.6 3.456 3.456v9.344c0 1.856-1.472 3.456-3.456 3.456h-9.056l-6.4 3.616c-0.544 0.256-1.216-0.256-0.96-0.8l1.344-2.816h-0.672zM14.272 22.4c0.128 0 0.256-0.128 0.256-0.128h9.344c1.184 0 2.144-0.928 2.144-2.144v-9.344c0-1.184-0.96-2.112-2.144-2.112h-15.744c-1.184 0-2.112 0.928-2.112 2.112v9.344c0 1.216 0.928 2.144 2.112 2.144h1.888c0.512 0 0.8 0.512 0.512 0.928l-0.928 1.856 4.672-2.656zM15.744 17.472c0.128-0.128 0.384-0.128 0.672 0l1.6 0.8-0.288-1.728c0-0.288 0-0.416 0.128-0.544l1.216-1.216-1.728-0.256c-0.288 0-0.416-0.128-0.544-0.384l-0.8-1.6-0.8 1.6c-0.128 0.128-0.256 0.256-0.544 0.384l-1.728 0.256 1.216 1.216c0.128 0.128 0.256 0.384 0.128 0.544l-0.256 1.728 1.728-0.8zM13.6 20.128c-0.544 0.256-1.056-0.128-0.928-0.672l0.384-2.656-1.984-1.856c-0.416-0.416-0.128-1.088 0.384-1.216l2.688-0.384 1.184-2.4c0.288-0.544 0.928-0.544 1.216 0l1.184 2.4 2.688 0.384c0.512 0.128 0.8 0.8 0.384 1.216l-1.984 1.856 0.384 2.656c0.128 0.544-0.544 0.928-0.928 0.672l-2.4-1.344-2.272 1.344zM28.256 13.184c-0.256-0.256-0.256-0.64 0-0.928 0.288-0.256 0.672-0.256 0.96 0l2.4 2.4c0.256 0.288 0.256 0.672 0 0.928l-2.4 2.4c-0.288 0.288-0.672 0.288-0.96 0-0.256-0.256-0.256-0.64 0-0.928l1.888-1.856-1.888-2.016zM3.872 13.184l-1.856 1.888 1.856 1.856c0.256 0.256 0.256 0.672 0 0.928-0.256 0.288-0.672 0.288-0.928 0l-2.4-2.4c-0.288-0.256-0.288-0.672 0-0.928l2.4-2.4c0.256-0.256 0.672-0.256 0.928 0s0.256 0.8 0 1.056z"></path></svg>',
            'slides'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M25.344 7.328h-18.688c-0.352 0-0.64 0.288-0.64 0.672v13.344c0 0.352 0.288 0.64 0.64 0.64h18.688c0.352 0 0.672-0.288 0.672-0.64v-13.344c0-0.384-0.32-0.672-0.672-0.672zM24.672 20.672h-17.344v-12h17.344v12zM4.48 11.52c-0.256-0.256-0.704-0.256-0.96 0l-2.656 2.688c-0.256 0.256-0.256 0.672 0 0.928l2.656 2.656c0.128 0.128 0.32 0.192 0.48 0.192s0.352-0.064 0.48-0.192c0.256-0.256 0.256-0.672 0-0.928l-2.208-2.208 2.208-2.176c0.256-0.256 0.256-0.704 0-0.96zM31.136 14.208l-2.656-2.688c-0.256-0.256-0.704-0.256-0.96 0s-0.256 0.704 0 0.96l2.208 2.176-2.208 2.208c-0.256 0.256-0.256 0.672 0 0.928 0.128 0.128 0.32 0.192 0.48 0.192s0.352-0.064 0.48-0.192l2.656-2.656c0.256-0.256 0.256-0.672 0-0.928z"></path></svg>',
            'wordpress'               => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512"><path d="M61.7 169.4l101.5 278C92.2 413 43.3 340.2 43.3 256c0-30.9 6.6-60.1 18.4-86.6zm337.9 75.9c0-26.3-9.4-44.5-17.5-58.7-10.8-17.5-20.9-32.4-20.9-49.9 0-19.6 14.8-37.8 35.7-37.8.9 0 1.8.1 2.8.2-37.9-34.7-88.3-55.9-143.7-55.9-74.3 0-139.7 38.1-177.8 95.9 5 .2 9.7.3 13.7.3 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l77.5 230.4L249.8 247l-33.1-90.8c-11.5-.7-22.3-2-22.3-2-11.5-.7-10.1-18.2 1.3-17.5 0 0 35.1 2.7 56 2.7 22.2 0 56.7-2.7 56.7-2.7 11.5-.7 12.8 16.2 1.4 17.5 0 0-11.5 1.3-24.3 2l76.9 228.7 21.2-70.9c9-29.4 16-50.5 16-68.7zm-139.9 29.3l-63.8 185.5c19.1 5.6 39.2 8.7 60.1 8.7 24.8 0 48.5-4.3 70.6-12.1-.6-.9-1.1-1.9-1.5-2.9l-65.4-179.2zm183-120.7c.9 6.8 1.4 14 1.4 21.9 0 21.6-4 45.8-16.2 76.2l-65 187.9C426.2 403 468.7 334.5 468.7 256c0-37-9.4-71.8-26-102.1zM504 256c0 136.8-111.3 248-248 248C119.2 504 8 392.7 8 256 8 119.2 119.2 8 256 8c136.7 0 248 111.2 248 248zm-11.4 0c0-130.5-106.2-236.6-236.6-236.6C125.5 19.4 19.4 125.5 19.4 256S125.6 492.6 256 492.6c130.5 0 236.6-106.1 236.6-236.6z"/></svg>',
            'magazine-grid'           => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 150 150"><defs><clipPath id="b"><rect width="150" height="150"/></clipPath></defs><g id="a" clip-path="url(#b)"><rect width="83" height="35" transform="translate(10 35)"/><rect width="36.667" height="35" transform="translate(10 80)"/><rect width="37" height="35" transform="translate(103 35)"/><rect width="36.667" height="35" transform="translate(56.667 80)"/><rect width="36.667" height="35" transform="translate(103.333 80)"/></g></svg>',
            'gallery-grid'            => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M9.344 5.984h-8c-0.384 0-0.672 0.32-0.672 0.672v8c0 0.384 0.288 0.672 0.672 0.672h8c0.352 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.32-0.672-0.672-0.672zM8.672 13.984h-6.656v-6.656h6.656v6.656zM20 5.984h-8c-0.352 0-0.672 0.32-0.672 0.672v8c0 0.384 0.32 0.672 0.672 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.672-0.672-0.672zM19.328 13.984h-6.656v-6.656h6.656v6.656zM30.656 5.984h-8c-0.352 0-0.64 0.32-0.64 0.672v8c0 0.384 0.288 0.672 0.64 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.672-0.672-0.672zM30.016 13.984h-6.688v-6.656h6.688v6.656zM9.344 16.672h-8c-0.384 0-0.672 0.288-0.672 0.672v8c0 0.352 0.288 0.64 0.672 0.64h8c0.352 0 0.672-0.288 0.672-0.64v-8c0-0.384-0.32-0.672-0.672-0.672zM8.672 24.672h-6.656v-6.688h6.656v6.688zM20 16.672h-8c-0.352 0-0.672 0.288-0.672 0.672v8c0 0.352 0.32 0.64 0.672 0.64h8c0.384 0 0.672-0.288 0.672-0.64v-8c0-0.384-0.288-0.672-0.672-0.672zM19.328 24.672h-6.656v-6.688h6.656v6.688zM30.656 16.672h-8c-0.352 0-0.64 0.288-0.64 0.672v8c0 0.352 0.288 0.64 0.64 0.64h8c0.384 0 0.672-0.288 0.672-0.64v-8c0-0.384-0.288-0.672-0.672-0.672zM30.016 24.672h-6.688v-6.688h6.688v6.688z"></path></svg>',
            'posts-grid'              => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M9.344 2.656h-8c-0.384 0-0.672 0.32-0.672 0.672v8c0 0.384 0.288 0.672 0.672 0.672h8c0.352 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.32-0.672-0.672-0.672zM8.672 10.656h-6.656v-6.656h6.656v6.656zM8 14.656c0.384 0 0.672-0.288 0.672-0.672s-0.288-0.64-0.672-0.64h-5.344c-0.352 0-0.64 0.288-0.64 0.64s0.288 0.672 0.64 0.672h5.344zM20 2.656h-8c-0.352 0-0.672 0.32-0.672 0.672v8c0 0.384 0.32 0.672 0.672 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.672-0.672-0.672zM19.328 10.656h-6.656v-6.656h6.656v6.656zM18.656 14.656c0.384 0 0.672-0.288 0.672-0.672s-0.288-0.64-0.672-0.64h-5.312c-0.384 0-0.672 0.288-0.672 0.64s0.288 0.672 0.672 0.672h5.312zM30.656 2.656h-8c-0.352 0-0.64 0.32-0.64 0.672v8c0 0.384 0.288 0.672 0.64 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.672-0.672-0.672zM30.016 10.656h-6.688v-6.656h6.688v6.656zM29.344 14.656c0.352 0 0.672-0.288 0.672-0.672s-0.32-0.64-0.672-0.64h-5.344c-0.352 0-0.672 0.288-0.672 0.64s0.32 0.672 0.672 0.672h5.344zM9.344 17.344h-8c-0.384 0-0.672 0.288-0.672 0.64v8c0 0.384 0.288 0.672 0.672 0.672h8c0.352 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.32-0.64-0.672-0.64zM8.672 25.344h-6.656v-6.688h6.656v6.688zM8 28h-5.344c-0.352 0-0.64 0.288-0.64 0.672s0.288 0.672 0.64 0.672h5.344c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM20 17.344h-8c-0.352 0-0.672 0.288-0.672 0.64v8c0 0.384 0.32 0.672 0.672 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.64-0.672-0.64zM19.328 25.344h-6.656v-6.688h6.656v6.688zM18.656 28h-5.312c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h5.312c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM30.656 17.344h-8c-0.352 0-0.64 0.288-0.64 0.64v8c0 0.384 0.288 0.672 0.64 0.672h8c0.384 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.288-0.64-0.672-0.64zM30.016 25.344h-6.688v-6.688h6.688v6.688zM29.344 28h-5.344c-0.352 0-0.672 0.288-0.672 0.672s0.32 0.672 0.672 0.672h5.344c0.352 0 0.672-0.32 0.672-0.672s-0.32-0.672-0.672-0.672z"></path></svg>',
            'posts-list'              => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"><path d="M8.672 0.672h-8c-0.384 0-0.672 0.288-0.672 0.672v8c0 0.352 0.288 0.64 0.672 0.64h8c0.352 0 0.672-0.288 0.672-0.64v-8c0-0.384-0.32-0.672-0.672-0.672zM8 8.672h-6.656v-6.688h6.656v6.688zM12.672 5.984h18.656c0.384 0 0.672-0.288 0.672-0.64s-0.288-0.672-0.672-0.672h-18.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.64 0.672 0.64zM12.672 3.328h8c0.352 0 0.672-0.288 0.672-0.672s-0.32-0.672-0.672-0.672h-8c-0.384 0-0.672 0.32-0.672 0.672s0.288 0.672 0.672 0.672zM31.328 7.328h-18.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h18.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM8.672 11.328h-8c-0.384 0-0.672 0.288-0.672 0.672v8c0 0.352 0.288 0.672 0.672 0.672h8c0.352 0 0.672-0.32 0.672-0.672v-8c0-0.384-0.32-0.672-0.672-0.672zM8 19.328h-6.656v-6.656h6.656v6.656zM31.328 15.328h-18.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h18.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672zM12.672 13.984h8c0.352 0 0.672-0.288 0.672-0.64s-0.32-0.672-0.672-0.672h-8c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.64 0.672 0.64zM31.328 17.984h-18.656c-0.384 0-0.672 0.32-0.672 0.672s0.288 0.672 0.672 0.672h18.656c0.384 0 0.672-0.288 0.672-0.672s-0.288-0.672-0.672-0.672zM8.672 21.984h-8c-0.384 0-0.672 0.32-0.672 0.672v8c0 0.384 0.288 0.672 0.672 0.672h8c0.352 0 0.672-0.288 0.672-0.672v-8c0-0.352-0.32-0.672-0.672-0.672zM8 30.016h-6.656v-6.688h6.656v6.688zM31.328 25.984h-18.656c-0.384 0-0.672 0.32-0.672 0.672s0.288 0.672 0.672 0.672h18.656c0.384 0 0.672-0.288 0.672-0.672s-0.288-0.672-0.672-0.672zM12.672 24.672h8c0.352 0 0.672-0.32 0.672-0.672s-0.32-0.672-0.672-0.672h-8c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672zM31.328 28.672h-18.656c-0.384 0-0.672 0.288-0.672 0.672s0.288 0.672 0.672 0.672h18.656c0.384 0 0.672-0.32 0.672-0.672s-0.288-0.672-0.672-0.672z"></path></svg>',
            'lock'                    => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512"><path d="M80 192V144C80 64.47 144.5 0 224 0C303.5 0 368 64.47 368 144V192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80zM144 192H304V144C304 99.82 268.2 64 224 64C179.8 64 144 99.82 144 144V192z"/></svg>',
            'desktop'                 => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M17.856 26.528c0.832 0 1.472 0.672 1.472 1.472v0.768c0 0.224-0.192 0.448-0.448 0.448h-5.76c-0.256 0-0.448-0.224-0.448-0.448v-0.768c0-0.8 0.64-1.472 1.472-1.472h3.712zM27.648 2.816c1.664 0 3.008 1.376 3.008 3.040v16.288c0 1.696-1.344 3.040-3.008 3.040h-23.296c-1.664 0-3.008-1.344-3.008-3.040v-16.288c0-1.664 1.344-3.040 3.008-3.040h23.296zM27.648 5.504h-23.296c-0.16 0-0.32 0.096-0.352 0.256v13.696h24v-13.6c0-0.192-0.128-0.32-0.288-0.352h-0.064z"></path></svg>',
            'tablet'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M25.216 1.344c1.536 0 2.784 1.248 2.784 2.784v23.744c0 1.536-1.248 2.784-2.784 2.784h-18.4c-1.568 0-2.816-1.248-2.816-2.784v-23.744c0-1.536 1.248-2.784 2.816-2.784h18.4zM25.216 4h-18.4c-0.096 0-0.128 0.064-0.16 0.128v0 23.744c0 0.064 0.064 0.128 0.128 0.128h18.432c0.064 0 0.096-0.064 0.128-0.128v0-23.744c0-0.064-0.064-0.128-0.128-0.128v0zM18.656 24.672c0.736 0 1.344 0.608 1.344 1.312v0.256c0 0.224-0.192 0.416-0.448 0.416h-7.104c-0.256 0-0.448-0.192-0.448-0.416v-0.256c0-0.704 0.608-1.312 1.344-1.312h5.312z"></path></svg>',
            'mobile'                  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 32 32"><path d="M22.4 1.344c1.536 0 2.816 1.248 2.816 2.784v23.744c0 1.536-1.28 2.784-2.816 2.784h-12.8c-1.536 0-2.784-1.248-2.784-2.784v-23.744c0-1.536 1.248-2.784 2.784-2.784h12.8zM22.4 4h-12.8c-0.064 0-0.128 0.064-0.128 0.128v0 23.744c0 0.064 0.064 0.128 0.128 0.128v0h12.8c0.064 0 0.128-0.064 0.128-0.128v0-23.744c0-0.064-0.032-0.128-0.128-0.128v0zM17.152 24.672c0.736 0 1.344 0.608 1.344 1.312v0.256c0 0.224-0.192 0.416-0.448 0.416h-3.776c-0.256 0-0.448-0.192-0.448-0.416v-0.256c0-0.704 0.608-1.312 1.344-1.312h1.984z"></path></svg>',
        ];
        if ( !isset( $svgs[$name] ) ) {
            return '';
        }
        return $svgs[$name];
    }

}
if ( !function_exists( 'yuki_image_url' ) ) {
    /**
     * Get image file url
     *
     * @param $path
     *
     * @return string
     */
    function yuki_image_url(  $path  ) : string {
        return trailingslashit( get_template_directory_uri() ) . 'dist/images/' . $path;
    }

}
if ( !function_exists( 'yuki_container_css' ) ) {
    /**
     * Get container css
     *
     * @param string $layout
     * @param string $style
     * @param array $css
     *
     * @return []|array|string[]
     */
    function yuki_container_css(  $layout = 'no-sidebar', $style = 'boxed', $css = []  ) {
        return array_merge( $css, [
            'yuki-container lg:flex flex-grow'      => true,
            'container mx-auto px-gutter'           => $style === 'boxed',
            'yuki-no-sidebar'                       => $layout !== 'right-sidebar' && $layout !== 'left-sidebar',
            'yuki-right-sidebar lg:flex-row'        => $layout === 'right-sidebar',
            'yuki-left-sidebar lg:flex-row-reverse' => $layout === 'left-sidebar',
        ] );
    }

}
if ( !function_exists( 'yuki_kses' ) ) {
    /**
     * Kses function support svg
     *
     * @param $data
     *
     * @return string
     */
    function yuki_kses(  $data  ) {
        $kses_defaults = wp_kses_allowed_html( 'post' );
        // add svg support
        $svg_args = array(
            'svg'      => array(
                'class'           => true,
                'aria-hidden'     => true,
                'aria-labelledby' => true,
                'role'            => true,
                'xmlns'           => true,
                'width'           => true,
                'height'          => true,
                'viewbox'         => true,
            ),
            'clipPath' => array(
                'id' => true,
            ),
            'rect'     => array(
                'width'     => true,
                'height'    => true,
                'fill'      => true,
                'transform' => true,
            ),
            'defs'     => array(),
            'g'        => array(
                'fill' => true,
            ),
            'title'    => array(
                'title' => true,
            ),
            'path'     => array(
                'd'    => true,
                'fill' => true,
            ),
        );
        return wp_kses( $data, array_merge( $kses_defaults, $svg_args ) );
    }

}
if ( !function_exists( 'yuki_scroll_reveal_args' ) ) {
    /**
     * Scroll reveal args
     *
     * @return array
     */
    function yuki_scroll_reveal_args() {
        return [
            'delay'    => absint( CZ::get( 'yuki_scroll_reveal_delay' ) ),
            'duration' => absint( CZ::get( 'yuki_scroll_reveal_duration' ) ),
            'interval' => absint( CZ::get( 'yuki_scroll_reveal_interval' ) ),
            'opacity'  => floatval( CZ::get( 'yuki_scroll_reveal_opacity' ) ),
            'scale'    => floatval( CZ::get( 'yuki_scroll_reveal_scale' ) ),
            'origin'   => CZ::get( 'yuki_scroll_reveal_origin' ),
            'distance' => CZ::get( 'yuki_scroll_reveal_distance' ),
        ];
    }

}
if ( !function_exists( 'yuki_post_metas' ) ) {
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     *
     * @param $id
     * @param array|string[] $items
     * @param array $args
     * @param null $options
     * @param array $settings
     */
    function yuki_post_metas(
        $id,
        array $items = ['posted_on', 'views', 'comments'],
        $args = [],
        $options = null,
        $settings = []
    ) {
        $default_args = [
            'before' => '',
            'after'  => '',
            'sep'    => '',
            'style'  => '',
        ];
        $options = $options ?? CZ::getFacadeRoot();
        extract( array_merge( $default_args, $args ) );
        $divider = $options->get( 'yuki_' . $id . '_meta_items_divider', $settings );
        $icon = $options->get( 'yuki_' . $id . '_meta_items_style', $settings ) === 'icon';
        echo $before;
        foreach ( $items as $item ) {
            if ( $item === 'byline' ) {
                $byline = sprintf( '%s', '<a class="' . $style . '" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>' );
                if ( !empty( $byline ) ) {
                    echo '<span class="byline meta-item"> ' . (( $icon ? IconsManager::render( $options->get( 'yuki_' . $id . '_byline_icon' ) ) : '' )) . $byline . '</span>';
                }
            } elseif ( $item === 'published' ) {
                $date_format = $options->get( 'yuki_' . $id . '_published_format', $settings );
                $show_modified = $options->checked( 'yuki_' . $id . '_show_modified_date', $settings );
                $time_string = '<time class="published updated" datetime="%1$s">%2$s</time>';
                if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
                    if ( $show_modified ) {
                        $time_string = '<time class="published hidden" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
                    } else {
                        $time_string = '<time class="published" datetime="%1$s">%2$s</time><time class="updated hidden" datetime="%3$s">%4$s</time>';
                    }
                }
                $time_string = sprintf(
                    $time_string,
                    esc_attr( get_the_date( 'c' ) ),
                    esc_html( get_the_date( $date_format ) ),
                    esc_attr( get_the_modified_date( 'c' ) ),
                    esc_html( get_the_modified_date( $date_format ) )
                );
                $posted_on = sprintf( '%s', '<a class="' . $style . '" href="' . esc_url( get_permalink() ) . '" rel="bookmark"><span class="entry-date">' . $time_string . '</span></a>' );
                if ( !empty( $posted_on ) ) {
                    echo '<span class="meta-item posted-on">' . (( $icon ? IconsManager::render( $options->get( 'yuki_' . $id . '_published_icon' ) ) : '' )) . $posted_on . '</span>';
                }
            } elseif ( $item === 'views' ) {
                $views = yuki_post_views();
                if ( $views <= 0 ) {
                    continue;
                }
                echo '<span class="meta-item views">' . (( $icon ? IconsManager::render( $options->get( 'yuki_' . $id . '_views_icon' ) ) : '' )) . $views . '</span>';
            } elseif ( $item === 'comments' ) {
                if ( !comments_open( get_the_ID() ) || get_comments_number() <= 0 ) {
                    continue;
                }
                echo '<span class="meta-item comments-link">';
                echo ( $icon ? IconsManager::render( $options->get( 'yuki_' . $id . '_comments_icon' ) ) : '' );
                comments_popup_link(
                    false,
                    false,
                    false,
                    $style
                );
                echo '</span>';
            }
            if ( $divider !== 'none' ) {
                echo '<span class="meta-divider">';
                echo yuki_image( $divider );
                echo '</span>';
            } else {
                echo '<span class="meta-empty-divider mr-2"></span>';
            }
        }
        echo $after;
    }

}
if ( !function_exists( 'yuki_post_categories' ) ) {
    /**
     * Prints HTML with categories information for the current post.
     *
     * @param string $before
     * @param string $after
     * @param array $style
     */
    function yuki_post_categories(  $before = '', $after = '', $style = []  ) {
        // Hide category for pages.
        if ( 'post' !== get_post_type() || empty( get_the_category() ) ) {
            return;
        }
        global $wp_rewrite;
        $style = esc_attr( Utils::clsx( $style ) );
        $rel = ( is_object( $wp_rewrite ) && $wp_rewrite->using_permalinks() ? 'rel="category tag"' : 'rel="category"' );
        echo $before;
        foreach ( get_the_category() as $category ) {
            echo '<a class="' . $style . '" href="' . esc_url( get_category_link( $category->term_id ) ) . '" ' . $rel . '>' . esc_html( $category->name ) . '</a>';
        }
        echo $after;
    }

}
if ( !function_exists( 'yuki_post_tags' ) ) {
    /**
     * Prints HTML with tags information for the current post.
     *
     * @param string $before
     * @param string $after
     * @param array $style
     */
    function yuki_post_tags(  $before = '', $after = '', $style = []  ) {
        // Hide tag text for pages.
        if ( 'post' !== get_post_type() ) {
            return;
        }
        $tags = get_the_tags();
        if ( is_wp_error( $tags ) || empty( $tags ) ) {
            return;
        }
        $style = esc_attr( Utils::clsx( $style ) );
        $tag_links = array_map( function ( $tag ) use($style) {
            return '<a class="' . $style . '" href="' . esc_url( get_tag_link( $tag->term_id ) ) . '" rel="tag">' . $tag->name . '</a>';
        }, $tags );
        /* Translators: used between list items, there is a space after the comma. */
        echo $before . implode( '', $tag_links ) . $after;
    }

}
if ( !function_exists( 'yuki_post_views' ) ) {
    /**
     * Post views count
     *
     * @param int $post_id
     *
     * @return int
     */
    function yuki_post_views(  $post_id = 0  ) {
        if ( function_exists( 'pvc_get_post_views' ) ) {
            return pvc_get_post_views( $post_id );
        }
        return -1;
    }

}
if ( !function_exists( 'yuki_post_structure_register_trans_strings__premium_only' ) ) {
}
if ( !function_exists( 'yuki_post_structure' ) ) {
    /**
     * Render post structure
     */
    function yuki_post_structure(
        $id,
        $structure,
        $metas,
        $args = []
    ) {
        $args = wp_parse_args( $args, [
            'trans_id'     => '',
            'title_link'   => false,
            'title_tag'    => 'h1',
            'excerpt_type' => 'full',
            'options'      => CZ::getFacadeRoot(),
            'settings'     => [],
        ] );
        $options = $args['options'];
        $settings = $args['settings'];
        $title_link = $args['title_link'];
        $title_tag = $args['title_tag'];
        $trans_id = $args['trans_id'];
        $more_text = $options->get( 'yuki_' . $id . '_excerpt_more_text', $settings );
        if ( !empty( $more_text ) && $options->checked( 'yuki_' . $id . '_excerpt_more_link', $settings ) ) {
            $more_text = '<a class="yuki-entry-excerpt-more yuki-entry-excerpt-more-link mx-1" href="' . esc_url( get_the_permalink() ) . '">' . $more_text . '</a>';
        } else {
            $more_text = '<span class="yuki-entry-excerpt-more yuki-entry-excerpt-more-text mx-1">' . $more_text . '</span>';
        }
        yuki_app()->instance( 'store.excerpt_more_text', (string) $more_text );
        yuki_app()->instance( 'store.excerpt_length', (string) $options->get( 'yuki_' . $id . '_excerpt_length', $settings ) );
        $content_open = false;
        ?>
		<?php 
        foreach ( $structure as $item ) {
            ?>
			<?php 
            if ( $item === 'thumbnail' && (has_post_thumbnail() || $options->checked( 'yuki_' . $id . '_thumbnail_use_fallback' ) && CZ::hasImage( 'yuki_post_featured_image_fallback' )) ) {
                ?>
				<?php 
                if ( $content_open ) {
                    $content_open = false;
                    echo '</div>';
                }
                ?>

                <a href="<?php 
                the_permalink();
                ?>" class="card-thumbnail entry-thumbnail last:mb-0">
					<?php 
                if ( has_post_thumbnail() ) {
                    the_post_thumbnail( $options->get( 'yuki_' . $id . '_thumbnail_size' ), [
                        'class' => 'w-full h-full',
                    ] );
                } else {
                    echo '<img class="w-full h-full wp-post-image" ' . Utils::render_attribute_string( CZ::imgAttrs( 'yuki_post_featured_image_fallback' ) ) . ' />';
                }
                ?>
                </a>
			<?php 
            } else {
                ?>
				<?php 
                if ( !$content_open ) {
                    $content_open = true;
                    echo '<div class="card-content">';
                }
                ?>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'title' && !$title_link ) {
                ?>
                <div class="entry-title mb-gutter last:mb-0">
					<?php 
                the_title( "<{$title_tag}>", "</{$title_tag}>" );
                ?>
                </div>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'title' && $title_link ) {
                ?>
				<?php 
                echo wp_kses_post( sprintf(
                    '<%1$s class="entry-title mb-half-gutter last:mb-0">%2$s %3$s</%1$s>',
                    $title_tag,
                    sprintf( '<a class="link" href="%1$s" rel="bookmark">%2$s</a>', esc_url( get_permalink() ), get_the_title() ),
                    ( get_edit_post_link() ? sprintf( '<span class="link text-xs font-normal"><a href="%1$s">%2$s</a></span>', get_edit_post_link(), __( 'Edit', 'yuki' ) ) : '' )
                ) );
                ?>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'metas' ) {
                ?>
                <div class="entry-metas mb-half-gutter last:mb-0">
					<?php 
                yuki_post_metas(
                    $id,
                    $metas,
                    [
                        'style' => 'entry-meta-link',
                    ],
                    $options,
                    $settings
                );
                ?>
                </div>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'categories' ) {
                ?>
				<?php 
                yuki_post_categories( '<div class="entry-categories cat-taxonomies break-words mb-2 last:mb-0" data-tax-type="' . $options->get( 'yuki_' . $id . '_tax_style_cats', $settings ) . '">', '</div>', ['entry-tax-item mr-2 last:mr-0'] );
                ?>
			<?php 
            }
            ?>

			<?php 
            if ( $item === 'tags' ) {
                ?>
				<?php 
                yuki_post_tags( '<div class="entry-tags cat-taxonomies mb-2 break-words last:mb-0" data-tax-type="' . $options->get( 'yuki_' . $id . '_tax_style_tags', $settings ) . '">', '</div>', ['entry-tax-item mr-2 last:mr-0'] );
                ?>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'excerpt' ) {
                ?>
                <div class="entry-excerpt yuki-raw-html mb-gutter last:mb-0">
					<?php 
                if ( $args['excerpt_type'] === 'full' ) {
                    echo get_the_content();
                } else {
                    echo get_the_excerpt();
                }
                ?>
                </div>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'read-more' ) {
                ?>
                <div class="mb-gutter last:mb-0">
                    <a class="yuki-button entry-read-more" href="<?php 
                the_permalink();
                ?>" rel="bookmark">
						<?php 
                $read_more_text = $options->get( 'yuki_' . $id . '_read_more_text', $settings );
                echo esc_html( $read_more_text );
                ?>
                    </a>
                </div>
			<?php 
            }
            ?>
			<?php 
            if ( $item === 'divider' ) {
                ?>
                <div class="entry-divider"></div>
			<?php 
            }
            ?>
		<?php 
        }
        ?>
		<?php 
    }

}
if ( !function_exists( 'yuki_post_elements_css' ) ) {
    /**
     * Generate dynamic css for post elements
     *
     * @param $scope_selector
     * @param $id
     * @param $elements
     * @param null $options
     * @param array $settings
     *
     * @return array
     */
    function yuki_post_elements_css(
        $scope_selector,
        $id,
        $elements,
        $options = null,
        array $settings = []
    ) {
        $options = $options ?? CZ::getFacadeRoot();
        $css = [];
        foreach ( $elements as $element ) {
            // title
            if ( $element === 'title' ) {
                $css["{$scope_selector} .entry-title"] = array_merge( Css::typography( $options->get( 'yuki_' . $id . '_title_typography', $settings ) ), Css::colors( $options->get( 'yuki_' . $id . '_title_color', $settings ), [
                    'initial' => '--yuki-initial-color',
                    'hover'   => '--yuki-hover-color',
                ] ) );
            }
            // taxonomies
            if ( $element === 'categories' || $element === 'tags' ) {
                $tax = ( $element === 'categories' ? '_cats' : '_tags' );
                $selector = ".entry-{$element}";
                $tax_css = Css::typography( $options->get( 'yuki_' . $id . '_tax_typography' . $tax, $settings ) );
                $tax_type = $options->get( 'yuki_' . $id . '_tax_style' . $tax, $settings );
                if ( $tax_type === 'default' ) {
                    $tax_css = array_merge( $tax_css, Css::colors( $options->get( 'yuki_' . $id . '_tax_default_color' . $tax, $settings ), [
                        'initial' => '--yuki-tax-text-initial',
                        'hover'   => '--yuki-tax-text-hover',
                    ] ) );
                } else {
                    $tax_css = array_merge( $tax_css, Css::colors( $options->get( 'yuki_' . $id . '_tax_badge_text_color' . $tax, $settings ), [
                        'initial' => '--yuki-tax-text-initial',
                        'hover'   => '--yuki-tax-text-hover',
                    ] ), Css::colors( $options->get( 'yuki_' . $id . '_tax_badge_bg_color' . $tax, $settings ), [
                        'initial' => '--yuki-tax-bg-initial',
                        'hover'   => '--yuki-tax-bg-hover',
                    ] ) );
                }
                $css["{$scope_selector} {$selector}"] = $tax_css;
            }
            // excerpt
            if ( $element === 'excerpt' ) {
                $css["{$scope_selector} .entry-excerpt"] = array_merge( Css::typography( $options->get( 'yuki_' . $id . '_excerpt_typography', $settings ) ), Css::colors( $options->get( 'yuki_' . $id . '_excerpt_color', $settings ), [
                    'initial'      => '--yuki-initial-color',
                    'link-initial' => '--yuki-link-initial-color',
                    'link-hover'   => '--yuki-link-hover-color',
                ] ) );
                $css["{$scope_selector} .entry-excerpt .yuki-entry-excerpt-more"] = Css::typography( $options->get( 'yuki_' . $id . '_excerpt_more_typography', $settings ) );
            }
            // divider
            if ( $element === 'divider' ) {
                $css["{$scope_selector} .entry-divider"] = Css::border( $options->get( 'yuki_' . $id . '_divider', $settings ), '--entry-divider' );
            }
            // metas
            if ( $element === 'metas' ) {
                $css["{$scope_selector} .entry-metas"] = array_merge( Css::typography( $options->get( 'yuki_' . $id . '_meta_typography', $settings ) ), Css::colors( $options->get( 'yuki_' . $id . '_meta_color', $settings ), [
                    'initial' => '--yuki-meta-link-initial-color',
                    'hover'   => '--yuki-meta-link-hover-color',
                ] ) );
            }
            // thumbnail
            if ( $element === 'thumbnail' ) {
                $css["{$scope_selector} .entry-thumbnail"] = array_merge( [
                    'height' => $options->get( 'yuki_' . $id . '_thumbnail_height', $settings ),
                ], Css::dimensions( $options->get( 'yuki_' . $id . '_thumbnail_radius', $settings ), 'border-radius' ), Css::shadow( $options->get( 'yuki_' . $id . '_thumbnail_shadow', $settings ) ) );
            }
            if ( $element === 'read-more' ) {
                $css["{$scope_selector} .entry-read-more"] = array_merge(
                    [
                        '--yuki-button-height' => $options->get( 'yuki_' . $id . '_read_more_min_height', $settings ),
                    ],
                    Css::typography( $options->get( 'yuki_' . $id . '_read_more_typography', $settings ) ),
                    Css::dimensions( $options->get( 'yuki_' . $id . '_read_more_padding', $settings ), '--yuki-button-padding' ),
                    Css::dimensions( $options->get( 'yuki_' . $id . '_read_more_radius', $settings ), '--yuki-button-radius' ),
                    Css::colors( $options->get( 'yuki_' . $id . '_read_more_text_color', $settings ), [
                        'initial' => '--yuki-button-text-initial-color',
                        'hover'   => '--yuki-button-text-hover-color',
                    ] ),
                    Css::colors( $options->get( 'yuki_' . $id . '_read_more_button_color', $settings ), [
                        'initial' => '--yuki-button-initial-color',
                        'hover'   => '--yuki-button-hover-color',
                    ] ),
                    Css::border( $options->get( 'yuki_' . $id . '_read_more_border', $settings ), '--yuki-button-border' )
                );
            }
        }
        return $css;
    }

}
if ( !function_exists( 'yuki_show_article_feature_image' ) ) {
    /**
     * Show feature image
     *
     * @param string $preview_location
     * @param $prefix
     */
    function yuki_show_article_feature_image(  $preview_location, $prefix  ) {
        $thumb_attrs = [
            'class' => 'article-featured-image prose prose-yuki mx-auto',
        ];
        if ( is_customize_preview() ) {
            $thumb_attrs['data-shortcut'] = 'border';
            $thumb_attrs['data-shortcut-location'] = $preview_location . ':' . $prefix . '_featured_image';
        }
        do_action( 'yuki_before_render_featured_image', $prefix );
        if ( has_post_thumbnail() || CZ::hasImage( $prefix . '_featured_image_fallback' ) ) {
            $width = CZ::get( $prefix . '_featured_image_width' );
            $attrs = array(
                'class' => Utils::clsx( [
                    'h-full object-center object-cover',
                    'w-full' => $width === 'default',
                    'alignwide' => $width === 'wide',
                    'alignfull' => $width === 'full'
                ] ),
            );
            echo '<div ' . Utils::render_attribute_string( $thumb_attrs ) . '>';
            if ( has_post_thumbnail() ) {
                the_post_thumbnail( CZ::get( $prefix . '_featured_image_size' ), $attrs );
            } else {
                // Show fallback image
                $attrs = array_merge( CZ::imgAttrs( $prefix . '_featured_image_fallback' ), $attrs );
                echo '<img ' . Utils::render_attribute_string( $attrs ) . '/>';
            }
            echo '</div>';
        }
        do_action( 'yuki_after_render_featured_image', $prefix );
    }

}
if ( !function_exists( 'yuki_show_article_header' ) ) {
    /**
     * Show article header
     *
     * @param $preview_location
     * @param string $type
     * @param bool $header
     */
    function yuki_show_article_header(  $preview_location, string $type = 'post', $header = true  ) {
        $prefix = 'yuki_' . $type;
        $header_elements = CZ::layers( $prefix . '_header_elements' );
        $has_featured_image = CZ::checked( "{$prefix}_featured_image" );
        $featured_image_pos = CZ::get( "{$prefix}_featured_image_position" );
        $header_available = $header && !empty( $header_elements ) && yuki_get_current_post_meta( 'disable-article-header' ) !== 'yes' && CZ::checked( "{$prefix}_header" );
        if ( is_front_page() && !is_home() ) {
            $header_available = CZ::checked( 'yuki_show_frontpage_header' );
        }
        $header_attrs = [
            'class' => 'yuki-article-header yuki-max-w-content mx-auto relative z-[1]',
        ];
        if ( is_customize_preview() ) {
            $header_attrs['data-shortcut'] = 'border';
            $header_attrs['data-shortcut-location'] = "{$preview_location}:{$prefix}_header";
        }
        ?>
		<?php 
        if ( $has_featured_image ) {
            if ( $featured_image_pos === 'above' ) {
                yuki_show_article_feature_image( $preview_location, $prefix );
            }
            if ( $featured_image_pos === 'behind' && $header_available ) {
                $url = ( has_post_thumbnail() ? get_the_post_thumbnail_url() : CZ::imgAttrs( $prefix . '_featured_image_fallback' )['src'] ?? '' );
                $background_attrs = [
                    'class' => 'yuki-article-header-background alignfull mb-gutter',
                ];
                if ( is_customize_preview() ) {
                    $background_attrs['data-shortcut'] = 'border';
                    $background_attrs['data-shortcut-location'] = $preview_location . ':' . $prefix . '_featured_image';
                }
                echo '<div ' . Utils::render_attribute_string( $background_attrs ) . '>';
                yuki_show_article_feature_image( $preview_location, $prefix );
                echo '<div class="container mx-auto px-gutter relative">';
            }
        }
        ?>

		<?php 
        if ( $header_available ) {
            ?>
            <header <?php 
            Utils::print_attribute_string( $header_attrs );
            ?>>
				<?php 
            yuki_post_structure(
                $type,
                $header_elements,
                CZ::layers( "{$prefix}_metas" ),
                [
                    'title_link'   => false,
                    'title_tag'    => CZ::get( "{$prefix}_title_tag" ),
                    'excerpt_type' => CZ::get( "{$prefix}_excerpt_type" ),
                ]
            );
            ?>
            </header>
		<?php 
        }
        ?>

		<?php 
        if ( $has_featured_image ) {
            if ( $featured_image_pos === 'behind' && $header_available ) {
                echo '</div></div>';
            }
            if ( $featured_image_pos === 'below' ) {
                yuki_show_article_feature_image( $preview_location, $prefix );
            }
        }
        ?>
		<?php 
    }

}
if ( !function_exists( 'yuki_show_article' ) ) {
    /**
     * Show article content
     *
     * @param $preview_location
     * @param string $type
     * @param bool $header
     */
    function yuki_show_article(  $preview_location, string $type = 'post', $header = true  ) {
        ?>
        <article id="post-<?php 
        the_ID();
        ?>" <?php 
        post_class();
        ?>>

			<?php 
        if ( CZ::get( "yuki_{$type}_featured_image_position" ) !== 'behind' ) {
            yuki_show_article_header( $preview_location, $type, $header );
        }
        ?>

            <!-- Article Content -->
            <div class="yuki-article-content yuki-entry-content clearfix mx-auto prose prose-yuki">

				<?php 
        the_content();
        wp_link_pages( array(
            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'yuki' ),
            'after'  => '</div>',
        ) );
        ?>
            </div>
        </article>
		<?php 
    }

}
if ( !function_exists( 'yuki_get_shapes' ) ) {
    /**
     * Get all shapes
     */
    function yuki_get_shapes(  $shape = null  ) {
        $shapes = array(
            'none'                  => array(
                'title'   => _x( 'None', 'Shapes', 'yuki' ),
                'options' => array(),
            ),
            'tilt'                  => array(
                'title'   => _x( 'Tilt', 'Shapes', 'yuki' ),
                'options' => array('shape_flip'),
            ),
            'mountains'             => array(
                'title'   => _x( 'Mountains (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip'),
            ),
            'drops'                 => array(
                'title'   => _x( 'Drops  (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'clouds'                => array(
                'title'   => _x( 'Clouds (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'zigzag'                => array(
                'title'   => _x( 'Zigzag (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array(),
            ),
            'pyramids'              => array(
                'title'   => _x( 'Pyramids (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'triangle'              => array(
                'title'   => _x( 'Triangle (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_invert'),
            ),
            'triangle-asymmetrical' => array(
                'title'   => _x( 'Triangle Asymmetrical (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'opacity-tilt'          => array(
                'title'   => _x( 'Tilt Opacity (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip'),
            ),
            'opacity-fan'           => array(
                'title'   => _x( 'Fan Opacity (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array(),
            ),
            'curve'                 => array(
                'title'   => _x( 'Curve (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_invert'),
            ),
            'curve-asymmetrical'    => array(
                'title'   => _x( 'Curve Asymmetrical (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'waves'                 => array(
                'title'   => _x( 'Waves (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip', 'shape_invert'),
            ),
            'wave-brush'            => array(
                'title'   => _x( 'Waves Brush (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip'),
            ),
            'waves-pattern'         => array(
                'title'   => _x( 'Waves Pattern (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_flip'),
            ),
            'arrow'                 => array(
                'title'   => _x( 'Arrow (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_invert'),
            ),
            'split'                 => array(
                'title'   => _x( 'Split (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_invert'),
            ),
            'book'                  => array(
                'title'   => _x( 'Book (Pro)', 'Shapes', 'yuki' ),
                'folder'  => 'images/shapes__premium_only',
                'options' => array('shape_invert'),
            ),
        );
        if ( $shape !== null ) {
            return ( isset( $shapes[$shape] ) ? $shapes[$shape] : null );
        }
        return $shapes;
    }

}
if ( !function_exists( 'yuki_image_attr' ) ) {
    /**
     * Get image attr
     *
     * @param $image
     *
     * @return array
     */
    function yuki_image_attr(  $image  ) {
        $image_attr = [];
        if ( isset( $image['url'] ) && !empty( $image['url'] ) ) {
            $attachment_id = $image['attachment_id'] ?? 0;
            $alt_attribute = ( $attachment_id <= 0 ? [] : get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) );
            $alt_attribute = ( !empty( $alt_attribute ) ? $alt_attribute : get_bloginfo( 'name' ) );
            $image_attr['src'] = esc_url( $image['url'] ?? '' );
            $image_attr['alt'] = esc_attr( $alt_attribute );
        }
        return $image_attr;
    }

}
if ( !function_exists( 'yuki_get_preloader' ) ) {
    /**
     * Get preloader
     *
     * @param $id
     *
     * @return array
     */
    function yuki_get_preloader(  $id  ) {
        $presets = [
            'preset-1'  => [
                'html'      => '<div class="yuki-preloader-1"></div>',
                'css'       => [
                    '.yuki-preloader-1'        => [
                        'width'         => '48px',
                        'height'        => '48px',
                        'margin'        => 'auto',
                        'border'        => '3px solid var(--yuki-preloader-accent)',
                        'border-radius' => '50%',
                        'display'       => 'inline-block',
                        'position'      => 'relative',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 1s linear infinite',
                    ],
                    '.yuki-preloader-1::after' => [
                        'content'             => "''",
                        'box-sizing'          => 'border-box',
                        'position'            => 'absolute',
                        'left'                => '50%',
                        'top'                 => '50%',
                        'transform'           => 'translate(-50%, -50%)',
                        'width'               => '40px',
                        'height'              => '40px',
                        'border-radius'       => '50%',
                        'border'              => '3px solid transparent',
                        'border-bottom-color' => 'var(--yuki-preloader-primary)',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'transform' => 'rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'rotate(360deg)',
                        ],
                    ],
                ],
            ],
            'preset-2'  => [
                'html'      => '<div class="yuki-preloader-2"></div>',
                'css'       => [
                    '.yuki-preloader-2' => [
                        'width'               => '48px',
                        'height'              => '48px',
                        'margin'              => 'auto',
                        'border'              => '5px solid var(--yuki-preloader-accent)',
                        'border-bottom-color' => 'var(--yuki-preloader-primary)',
                        'border-radius'       => '50%',
                        'display'             => 'inline-block',
                        'box-sizing'          => 'border-box',
                        'animation'           => 'preloaderAnim 1s linear infinite',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'transform' => 'rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'rotate(360deg)',
                        ],
                    ],
                ],
            ],
            'preset-3'  => [
                'html'      => '<div class="yuki-preloader-3"></div>',
                'css'       => [
                    '.yuki-preloader-3'                                  => [
                        'width'         => '48px',
                        'height'        => '48px',
                        'margin'        => 'auto',
                        'border-radius' => '50%',
                        'display'       => 'inline-block',
                        'position'      => 'relative',
                        'border'        => '3px solid',
                        'border-color'  => 'var(--yuki-preloader-accent) var(--yuki-preloader-accent) transparent transparent',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 1s linear infinite',
                    ],
                    '.yuki-preloader-3::after,.yuki-preloader-3::before' => [
                        'content'          => "''",
                        'box-sizing'       => 'border-box',
                        'position'         => 'absolute',
                        'left'             => '0',
                        'right'            => '0',
                        'top'              => '0',
                        'bottom'           => '0',
                        'margin'           => 'auto',
                        'border'           => '3px solid',
                        'border-color'     => 'transparent transparent var(--yuki-preloader-primary ) var(--yuki-preloader-primary )',
                        'width'            => '40px',
                        'height'           => '40px',
                        'border-radius'    => '50%',
                        'animation'        => 'rotationBack 0.5s linear infinite',
                        'transform-origin' => 'center center',
                    ],
                    '.yuki-preloader-3::before'                          => [
                        'width'        => '32px',
                        'height'       => '32px',
                        'border-color' => 'var(--yuki-preloader-accent ) var(--yuki-preloader-accent ) transparent transparent',
                        'animation'    => 'rotation 1.5s linear infinite',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'transform' => 'rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'rotate(360deg)',
                        ],
                    ],
                    'rotationBack'  => [
                        '0%'   => [
                            'transform' => 'rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'rotate(-360deg)',
                        ],
                    ],
                ],
            ],
            'preset-4'  => [
                'html'      => '<div class="yuki-preloader-4"></div>',
                'css'       => [
                    '.yuki-preloader-4'                                  => [
                        'transform'     => 'rotateZ(45deg)',
                        'perspective'   => '1000px',
                        'border-radius' => '50%',
                        'width'         => '48px',
                        'height'        => '48px',
                        'margin'        => 'auto',
                        'color'         => 'var(--yuki-preloader-accent)',
                    ],
                    '.yuki-preloader-4::before,.yuki-preloader-4::after' => [
                        'content'       => "''",
                        'display'       => 'block',
                        'position'      => 'absolute',
                        'top'           => '0',
                        'left'          => '0',
                        'width'         => 'inherit',
                        'height'        => 'inherit',
                        'border-radius' => '50%',
                        'transform'     => 'rotateX(70deg)',
                        'animation'     => '1s spin linear infinite',
                    ],
                    '.yuki-preloader-4::after'                           => [
                        'color'           => 'var(--yuki-preloader-primary)',
                        'transform'       => 'rotateY(70deg)',
                        'animation-delay' => '.4s',
                    ],
                ],
                'keyframes' => [
                    'rotate'    => [
                        '0%'   => [
                            'transform' => 'translate(-50%, -50%) rotateZ(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'translate(-50%, -50%) rotateZ(360deg)',
                        ],
                    ],
                    'rotateccw' => [
                        '0%'   => [
                            'transform' => 'translate(-50%, -50%) rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'translate(-50%, -50%) rotate(-360deg)',
                        ],
                    ],
                    'spin'      => [
                        '0%,'  => [],
                        '100%' => [
                            'box-shadow' => '.2em 0px 0 0px currentcolor',
                        ],
                        '12%'  => [
                            'box-shadow' => '.2em .2em 0 0 currentcolor',
                        ],
                        '25%'  => [
                            'box-shadow' => '0 .2em 0 0px currentcolor',
                        ],
                        '37%'  => [
                            'box-shadow' => '-.2em .2em 0 0 currentcolor',
                        ],
                        '50%'  => [
                            'box-shadow' => '-.2em 0 0 0 currentcolor',
                        ],
                        '62%'  => [
                            'box-shadow' => '-.2em -.2em 0 0 currentcolor',
                        ],
                        '75%'  => [
                            'box-shadow' => '0px -.2em 0 0 currentcolor',
                        ],
                        '87%'  => [
                            'box-shadow' => '.2em -.2em 0 0 currentcolor',
                        ],
                    ],
                ],
            ],
            'preset-5'  => [
                'html'      => '<div class="yuki-preloader-5"></div>',
                'css'       => [
                    '.yuki-preloader-5'        => [
                        'width'         => '48px',
                        'height'        => '48px',
                        'margin'        => 'auto',
                        'border-radius' => '50%',
                        'display'       => 'inline-block',
                        'border-top'    => '4px solid var(--yuki-preloader-accent)',
                        'border-right'  => '4px solid transparent',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 1s linear infinite',
                    ],
                    '.yuki-preloader-5::after' => [
                        'content'       => "''",
                        'box-sizing'    => 'border-box',
                        'position'      => 'absolute',
                        'left'          => '0',
                        'top'           => '0',
                        'width'         => '48px',
                        'height'        => '48px',
                        'border-radius' => '50%',
                        'border-left'   => '4px solid var(--yuki-preloader-primary)',
                        'border-bottom' => '4px solid transparent',
                        'animation'     => 'preloaderAnim 0.5s linear infinite reverse',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'transform' => 'rotate(0deg)',
                        ],
                        '100%' => [
                            'transform' => 'rotate(360deg)',
                        ],
                    ],
                ],
            ],
            'preset-6'  => [
                'html'      => '<div class="yuki-preloader-6"></div>',
                'css'       => [
                    '.yuki-preloader-6' => [
                        'position'      => 'relative',
                        'margin'        => 'auto',
                        'border'        => '24px solid var(--yuki-preloader-accent)',
                        'border-radius' => '50%',
                        'transform'     => 'rotate(45deg)',
                        'animation'     => 'pieFill 3s linear infinite',
                    ],
                ],
                'keyframes' => [
                    'pieFill' => [
                        '0%, 19%'   => [
                            'border-color' => 'var(--yuki-preloader-accent) var(--yuki-preloader-accent) var(--yuki-preloader-accent) var(--yuki-preloader-accent)',
                        ],
                        '20%, 39%'  => [
                            'border-color' => 'var(--yuki-preloader-primary) var(--yuki-preloader-accent) var(--yuki-preloader-accent) var(--yuki-preloader-accent)',
                        ],
                        '40%, 59%'  => [
                            'border-color' => 'var(--yuki-preloader-primary) var(--yuki-preloader-primary) var(--yuki-preloader-accent) var(--yuki-preloader-accent)',
                        ],
                        '60%, 79%'  => [
                            'border-color' => 'var(--yuki-preloader-primary) var(--yuki-preloader-primary) var(--yuki-preloader-primary) var(--yuki-preloader-accent)',
                        ],
                        '80%, 100%' => [
                            'border-color' => 'var(--yuki-preloader-primary) var(--yuki-preloader-primary) var(--yuki-preloader-primary) var(--yuki-preloader-primary)',
                        ],
                    ],
                ],
            ],
            'preset-7'  => [
                'html'      => '<div class="yuki-preloader-7"></div>',
                'css'       => [
                    '.yuki-preloader-7'                                   => [
                        'width'         => '8px',
                        'height'        => '40px',
                        'border-radius' => '4px',
                        'display'       => 'block',
                        'margin'        => '20px auto',
                        'position'      => 'relative',
                        'background'    => 'currentColor',
                        'color'         => 'var(--yuki-preloader-accent)',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 0.3s 0.3s linear infinite alternate',
                    ],
                    '.yuki-preloader-7::after, .yuki-preloader-7::before' => [
                        'content'       => "''",
                        'width'         => '8px',
                        'height'        => '40px',
                        'border-radius' => '4px',
                        'background'    => 'currentColor',
                        'position'      => 'absolute',
                        'top'           => '50%',
                        'transform'     => 'translateY(-50%)',
                        'left'          => '20px',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 0.3s 0.45s linear infinite alternate',
                    ],
                    '.yuki-preloader-7::before'                           => [
                        'left'            => '-20px',
                        'animation-delay' => '0s',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'height' => '48px',
                        ],
                        '100%' => [
                            'height' => '4px',
                        ],
                    ],
                ],
            ],
            'preset-8'  => [
                'html'      => '<div class="yuki-preloader-8"></div>',
                'css'       => [
                    '.yuki-preloader-8' => [
                        'width'         => '48px',
                        'height'        => '6px',
                        'display'       => 'block',
                        'margin'        => 'auto',
                        'position'      => 'relative',
                        'border-radius' => '4px',
                        'color'         => 'var(--yuki-preloader-accent)',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 0.6s linear infinite',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'box-shadow' => '-10px 20px, 10px 35px, 0px 50px',
                        ],
                        '25%'  => [
                            'box-shadow' => '0px 20px, 0px 35px, 10px 50px',
                        ],
                        '50%'  => [
                            'box-shadow' => '10px 20px, -10px 35px, 0px 50px',
                        ],
                        '75%'  => [
                            'box-shadow' => '0px 20px, 0px 35px, -10px 50px',
                        ],
                        '100%' => [
                            'box-shadow' => '-10px 20px, 10px 35px, 0px 50px',
                        ],
                    ],
                ],
            ],
            'preset-9'  => [
                'html'      => '<div class="yuki-preloader-9"></div>',
                'css'       => [
                    '.yuki-preloader-9' => [
                        'width'         => '8px',
                        'height'        => '48px',
                        'margin'        => 'auto',
                        'display'       => 'inline-block',
                        'position'      => 'relative',
                        'border-radius' => '4px',
                        'color'         => 'var(--yuki-preloader-accent)',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 0.6s linear infinite',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'box-shadow' => '20px -10px, 40px 10px, 60px 0px',
                        ],
                        '25%'  => [
                            'box-shadow' => '20px 0px, 40px 0px, 60px 10px',
                        ],
                        '50%'  => [
                            'box-shadow' => '20px 10px, 40px -10px, 60px 0px',
                        ],
                        '75%'  => [
                            'box-shadow' => '20px 0px, 40px 0px, 60px -10px',
                        ],
                        '100%' => [
                            'box-shadow' => '20px -10px, 40px 10px, 60px 0px',
                        ],
                    ],
                ],
            ],
            'preset-10' => [
                'html'      => '<div class="yuki-preloader-10"></div>',
                'css'       => [
                    '.yuki-preloader-10'                                   => [
                        'width'         => '4.8px',
                        'height'        => '4.8px',
                        'display'       => 'block',
                        'margin'        => '20px auto',
                        'position'      => 'relative',
                        'border-radius' => '4px',
                        'color'         => 'var(--yuki-preloader-accent)',
                        'background'    => 'currentColor',
                        'box-sizing'    => 'border-box',
                        'animation'     => 'preloaderAnim 0.3s 0.3s linear infinite alternate',
                    ],
                    '.yuki-preloader-10::after,.yuki-preloader-10::before' => [
                        'content'       => "''",
                        'box-sizing'    => 'border-box',
                        'width'         => '4.8px',
                        'height'        => '4.8px',
                        'border-radius' => '4px',
                        'background'    => 'currentColor',
                        'position'      => 'absolute',
                        'left'          => '50%',
                        'transform'     => 'translateX(-50%)',
                        'top'           => '15px',
                        'animation'     => 'preloaderAnim 0.3s 0.45s linear infinite alternate',
                    ],
                    '.yuki-preloader-10::after'                            => [
                        'top'             => '-15px',
                        'animation-delay' => '0s',
                    ],
                ],
                'keyframes' => [
                    'preloaderAnim' => [
                        '0%'   => [
                            'width' => '4.8px',
                        ],
                        '100%' => [
                            'width' => '48px',
                        ],
                    ],
                ],
            ],
        ];
        return $presets[$id] ?? [
            'html' => '',
            'css'  => [],
        ];
    }

}
if ( !function_exists( 'yuki_show_share_box' ) ) {
    /**
     * @param $type
     * @param $location
     */
    function yuki_show_share_box(  $type, $location  ) {
        $color = CZ::get( 'yuki_' . $type . '_share_box_icons_color_type' );
        $shape = CZ::get( 'yuki_' . $type . '_share_box_icons_shape' );
        $fill = CZ::get( 'yuki_' . $type . '_share_box_shape_fill_type' );
        $attrs = [
            'class' => Utils::clsx( [
                'yuki-socials',
                'yuki-' . $type . '-socials',
                'yuki-socials-' . $color,
                'yuki-socials-' . $shape,
                'yuki-socials-' . $fill => $shape !== 'none'
            ] ),
        ];
        if ( is_customize_preview() ) {
            $attrs['data-shortcut'] = 'border';
            $attrs['data-shortcut-location'] = $location;
        }
        $link_attrs = [
            'class' => 'yuki-social-link',
        ];
        if ( CZ::checked( 'yuki_' . $type . '_share_box_open_new_tab' ) ) {
            $link_attrs['target'] = '_blank';
        }
        if ( CZ::checked( 'yuki_' . $type . '_share_box_no_follow' ) ) {
            $link_attrs['rel'] = 'nofollow';
        }
        $socials = CZ::repeater( 'yuki_social_networks' );
        ?>
        <div class="mx-auto yuki-max-w-content">
            <div <?php 
        Utils::print_attribute_string( $attrs );
        ?>>
				<?php 
        foreach ( $socials as $social ) {
            if ( !empty( $social['share'] ) ) {
                $home_url = Utils::encode_uri_component( get_the_permalink() );
                $share_url = str_replace( '{url}', $home_url, str_replace( '{text}', Utils::encode_uri_component( get_the_title() ), $social['share'] ) );
                ?>
                        <a <?php 
                Utils::print_attribute_string( $link_attrs );
                ?>
                                style="--yuki-official-color: <?php 
                echo esc_attr( $social['color']['official'] ?? 'var(--yuki-primary-active)' );
                ?>;"
                                href="<?php 
                echo esc_url( $share_url );
                ?>">
                            <span class="yuki-social-icon">
                                <?php 
                IconsManager::print( $social['icon'] );
                ?>
                            </span>
                        </a>
						<?php 
            }
        }
        ?>
            </div>
        </div>
		<?php 
    }

}
if ( !function_exists( 'yuki_form_style_presets' ) ) {
    /**
     * @param $style
     *
     * @return array
     */
    function yuki_form_style_presets() {
        return [
            '.yuki-form-classic' => [],
            '.yuki-form-modern'  => [
                '--yuki-form-border-top'             => 'none',
                '--yuki-form-border-right'           => 'none',
                '--yuki-form-border-left'            => 'none',
                '--yuki-form-border-bottom'          => '2px solid var(--yuki-form-border-color)',
                '--yuki-form-checkbox-border-top'    => '2px solid var(--yuki-form-background-color)',
                '--yuki-form-checkbox-border-right'  => '2px solid var(--yuki-form-background-color)',
                '--yuki-form-checkbox-border-left'   => '2px solid var(--yuki-form-background-color)',
                '--yuki-form-checkbox-border-bottom' => '2px solid var(--yuki-form-border-color)',
            ],
        ];
    }

}
if ( !function_exists( 'yuki_content_link_style_preset' ) ) {
    /**
     * @param $style
     *
     * @return array
     */
    function yuki_content_link_style_preset(  $scope, $style, $css = []  ) {
        $presets = [
            'underline'       => [
                $scope => [
                    'text-decoration' => 'underline',
                ],
            ],
            'plain'           => [
                $scope => [
                    'text-decoration' => 'none',
                ],
            ],
            'hover-underline' => [
                $scope            => [
                    'text-decoration' => 'none',
                ],
                $scope . ':hover' => [
                    'text-decoration' => 'underline',
                ],
            ],
        ];
        return array_merge( $css, $presets[$style] ?? $presets['underline'] );
    }

}
if ( !function_exists( 'yuki_show_archive_header' ) ) {
    /**
     * Show archive header
     */
    function yuki_show_archive_header() {
        $should_show_archive_header = !(is_home() && CZ::checked( 'yuki_disable_blogs_archive_header' ) || is_search() && CZ::checked( 'yuki_disable_search_archive_header' ) || is_search() && !have_posts() || is_author() && CZ::checked( 'yuki_disable_author_archive_header' ) || is_tag() && CZ::checked( 'yuki_disable_tag_archive_header' ) || is_category() && CZ::checked( 'yuki_disable_category_archive_header' ) || is_date() && CZ::checked( 'yuki_disable_date_archive_header' ) || yuki_is_woo_shop() && CZ::checked( 'yuki_disable_shop_archive_header' ));
        if ( !apply_filters( 'yuki_should_show_archive_header', $should_show_archive_header ) ) {
            return;
        }
        $attrs = [
            'class' => Utils::clsx( array(
                'yuki-archive-header'             => true,
                'yuki-archive-header-has-overlay' => CZ::checked( 'yuki_archive_header_has_overlay' ),
            ) ),
        ];
        if ( is_customize_preview() ) {
            $attrs['data-shortcut'] = 'border';
            $attrs['data-shortcut-location'] = 'yuki_archive:yuki_archive_header';
        }
        ?>
        <section <?php 
        \LottaFramework\Utils::print_attribute_string( $attrs );
        ?>>
            <div class="container mx-auto px-gutter">
				<?php 
        if ( is_search() ) {
            ?>
                    <h1 class="archive-title">
						<?php 
            /* translators: %s: Keywords searched by users */
            printf( CZ::get( 'yuki_search_archive_header_prefix' ) . ' %s', '<span>' . get_search_query() . '</span>' );
            ?>
                    </h1>
					<?php 
        } else {
            if ( yuki_is_woo_shop() ) {
                ?>
                    <h1 class="archive-title"><?php 
                woocommerce_page_title();
                ?></h1>
                    <div class="archive-description mt-half-gutter"><?php 
                woocommerce_taxonomy_archive_description();
                ?></div>
					<?php 
            } else {
                the_archive_title( '<h1 class="archive-title">', '</h1>' );
                the_archive_description( '<div class="archive-description mt-half-gutter">', '</div>' );
            }
        }
        ?>
            </div>
        </section>
		<?php 
    }

}
if ( !function_exists( 'yuki_get_current_post_meta' ) ) {
    /**
     * Get post meta value
     *
     * @param $id
     * @param bool $single
     *
     * @return mixed
     */
    function yuki_get_current_post_meta(  $id, $single = true  ) {
        global $post;
        if ( !$post ) {
            return '';
        }
        $meta = get_post_meta( $post->ID, $id, $single );
        $query = get_query_var( $id );
        return ( !empty( $query ) && ($meta === 'default' || $meta === '') ? $query : $meta );
    }

}
if ( !function_exists( 'yuki_light_color_presets' ) ) {
    /**
     * @return mixed|null
     */
    function yuki_light_color_presets() {
        return apply_filters( 'yuki_light_color_palettes', [
            [
                'yuki-light-primary-color'  => '#10b981',
                'yuki-light-primary-active' => '#0d9488',
                'yuki-light-accent-color'   => '#475569',
                'yuki-light-accent-active'  => '#334155',
                'yuki-light-base-300'       => '#c5c6c5',
                'yuki-light-base-200'       => '#e0e2e0',
                'yuki-light-base-100'       => '#f8f9f8',
                'yuki-light-base-color'     => '#ffffff',
            ],
            [
                'yuki-light-primary-color'  => '#ffc300',
                'yuki-light-primary-active' => '#fca311',
                'yuki-light-accent-color'   => '#003566',
                'yuki-light-accent-active'  => '#14213d',
                'yuki-light-base-300'       => '#c5c5c5',
                'yuki-light-base-200'       => '#e0e0e0',
                'yuki-light-base-100'       => '#f8f8f8',
                'yuki-light-base-color'     => '#ffffff',
            ],
            [
                'yuki-light-primary-color'  => '#7678ed',
                'yuki-light-primary-active' => '#5253cd',
                'yuki-light-accent-color'   => '#533f68',
                'yuki-light-accent-active'  => '#35095d',
                'yuki-light-base-300'       => '#c5c6c5',
                'yuki-light-base-200'       => '#e0e2e0',
                'yuki-light-base-100'       => '#f8f9f8',
                'yuki-light-base-color'     => '#ffffff',
            ],
            [
                'yuki-light-primary-color'  => '#00a4db',
                'yuki-light-primary-active' => '#096dd9',
                'yuki-light-accent-color'   => '#687385',
                'yuki-light-accent-active'  => '#000c2d',
                'yuki-light-base-300'       => '#dbdddf',
                'yuki-light-base-200'       => '#eaecee',
                'yuki-light-base-100'       => '#f7f8f9',
                'yuki-light-base-color'     => '#ffffff',
            ],
            [
                'yuki-light-primary-color'  => '#dc2626',
                'yuki-light-primary-active' => '#b91c1c',
                'yuki-light-accent-color'   => '#6b7280',
                'yuki-light-accent-active'  => '#374151',
                'yuki-light-base-300'       => '#e1d5cb',
                'yuki-light-base-200'       => '#ece9e7',
                'yuki-light-base-100'       => '#f7f5f4',
                'yuki-light-base-color'     => '#fefcfc',
            ],
            [
                'yuki-light-primary-color'  => '#000000',
                'yuki-light-primary-active' => '#000000',
                'yuki-light-accent-color'   => '#000000',
                'yuki-light-accent-active'  => '#000000',
                'yuki-light-base-300'       => '#000000',
                'yuki-light-base-200'       => '#000000',
                'yuki-light-base-100'       => '#ffffff',
                'yuki-light-base-color'     => '#ffffff',
            ]
        ] );
    }

}
if ( !function_exists( 'yuki_dark_color_presets' ) ) {
    /**
     * @return mixed|null
     */
    function yuki_dark_color_presets() {
        return apply_filters( 'yuki_dark_color_palettes', [
            [
                'yuki-dark-primary-color'  => '#10b981',
                'yuki-dark-primary-active' => '#0d9488',
                'yuki-dark-accent-color'   => '#a3a9a3',
                'yuki-dark-accent-active'  => '#f3f4f6',
                'yuki-dark-base-300'       => '#3f463f',
                'yuki-dark-base-200'       => '#2f2f2f',
                'yuki-dark-base-100'       => '#212a33',
                'yuki-dark-base-color'     => '#17212a',
            ],
            [
                'yuki-dark-primary-color'  => '#ffc300',
                'yuki-dark-primary-active' => '#fca311',
                'yuki-dark-accent-color'   => '#c5c5c5',
                'yuki-dark-accent-active'  => '#e5e5e5',
                'yuki-dark-base-300'       => '#4f4f4f',
                'yuki-dark-base-200'       => '#373747',
                'yuki-dark-base-100'       => '#2a2a2a',
                'yuki-dark-base-color'     => '#171717',
            ],
            [
                'yuki-dark-primary-color'  => '#7678ed',
                'yuki-dark-primary-active' => '#5253cd',
                'yuki-dark-accent-color'   => '#9f9baa',
                'yuki-dark-accent-active'  => '#f3f4f6',
                'yuki-dark-base-300'       => '#3f463f',
                'yuki-dark-base-200'       => '#2f2f2f',
                'yuki-dark-base-100'       => '#212a33',
                'yuki-dark-base-color'     => '#17212a',
            ],
            [
                'yuki-dark-primary-color'  => '#00a4db',
                'yuki-dark-primary-active' => '#096dd9',
                'yuki-dark-accent-color'   => '#c2c3c8',
                'yuki-dark-accent-active'  => '#fefefe',
                'yuki-dark-base-300'       => '#656571',
                'yuki-dark-base-200'       => '#484852',
                'yuki-dark-base-100'       => '#32323a',
                'yuki-dark-base-color'     => '#26262d',
            ],
            [
                'yuki-dark-primary-color'  => '#dc2626',
                'yuki-dark-primary-active' => '#b91c1c',
                'yuki-dark-accent-color'   => '#a1a1aa',
                'yuki-dark-accent-active'  => '#e4e4e7',
                'yuki-dark-base-300'       => '#3f3f46',
                'yuki-dark-base-200'       => '#27272a',
                'yuki-dark-base-100'       => '#262626',
                'yuki-dark-base-color'     => '#1e1c1c',
            ],
            [
                'yuki-dark-primary-color'  => '#ffffff',
                'yuki-dark-primary-active' => '#ffffff',
                'yuki-dark-accent-color'   => '#ffffff',
                'yuki-dark-accent-active'  => '#ffffff',
                'yuki-dark-base-300'       => '#ffffff',
                'yuki-dark-base-200'       => '#ffffff',
                'yuki-dark-base-100'       => '#000000',
                'yuki-dark-base-color'     => '#000000',
            ]
        ] );
    }

}
if ( !function_exists( 'yuki_get_query_page' ) ) {
    /**
     * Get paged value
     *
     * @param $page_key
     *
     * @return int|mixed
     */
    function yuki_get_query_page(  $page_key  ) {
        // Get Paged
        if ( $page_key && !empty( $_GET[$page_key] ) ) {
            $paged = $_GET[$page_key];
        } else {
            if ( get_query_var( 'paged' ) ) {
                $paged = get_query_var( 'paged' );
            } else {
                if ( get_query_var( 'page' ) ) {
                    $paged = get_query_var( 'page' );
                } else {
                    $paged = 1;
                }
            }
        }
        return absint( $paged );
    }

}
if ( !function_exists( 'yuki_show_query_pagination' ) ) {
    /**
     * Show pagination for any query
     *
     * @return void
     */
    function yuki_show_query_pagination(  $query, $args  ) {
        $args = wp_parse_args( $args, [
            'page_key' => 'paged',
            'prefix'   => '',
            'options'  => null,
            'settings' => [],
            'class'    => '',
        ] );
        $page_key = $args['page_key'];
        $prefix = $args['prefix'];
        $options = $args['options'];
        $settings = $args['settings'];
        $class = $args['class'];
        global $wp_query;
        $pages = ( $query ? $query->max_num_pages : $wp_query->max_num_pages );
        $options = $options ?? CZ::getFacadeRoot();
        // Get Paged
        $paged = yuki_get_query_page( $page_key );
        // Don't print empty markup if there's only one page.
        if ( $pages < 2 ) {
            return;
        }
        $type = $options->get( $prefix . 'pagination_type', $settings );
        $show_disabled_button = $options->checked( $prefix . 'pagination_disabled_button', $settings );
        $css = ['yuki-pagination yuki-scroll-reveal'];
        $pagination_attrs = [
            'class'                     => Utils::clsx( $css, $class ),
            'data-pagination-type'      => $type,
            'data-pagination-max-pages' => $pages,
        ];
        if ( is_customize_preview() ) {
            $pagination_attrs['data-shortcut'] = 'border';
            $pagination_attrs['data-shortcut-location'] = 'yuki_posts:yuki_archive_pagination_section';
        }
        $btn_class = 'yuki-btn';
        $current_btn_class = $btn_class . ' yuki-btn-active';
        $disabled_btn_class = $btn_class . ' yuki-btn-disabled';
        $show_previous_button = function ( $disabled = false ) use(
            $options,
            $prefix,
            $settings,
            $paged,
            $page_key,
            $btn_class,
            $disabled_btn_class
        ) {
            $prev_type = $options->get( $prefix . 'pagination_prev_next_type', $settings );
            if ( $disabled ) {
                echo '<span class="' . esc_attr( $disabled_btn_class . ' yuki-prev-btn yuki-prev-btn-' . $prev_type ) . '">';
            } else {
                echo '<a href="' . esc_url( add_query_arg( $page_key, $paged - 1 ) ) . '" class="' . esc_attr( $btn_class . ' yuki-prev-btn yuki-prev-btn-' . $prev_type ) . '">';
            }
            echo '<span>';
            if ( $prev_type === 'text' ) {
                esc_html_e( $options->get( $prefix . 'pagination_prev_text', $settings ) );
            } else {
                IconsManager::print( $options->get( $prefix . 'pagination_prev_icon', $settings ) );
            }
            echo '</span>';
            echo ( $disabled ? '</span>' : '</a>' );
        };
        $show_next_button = function ( $disabled = false ) use(
            $options,
            $prefix,
            $settings,
            $paged,
            $page_key,
            $btn_class,
            $disabled_btn_class
        ) {
            $next_type = $options->get( $prefix . 'pagination_prev_next_type', $settings );
            if ( $disabled ) {
                echo '<span class="' . esc_attr( $disabled_btn_class . ' yuki-next-btn yuki-next-btn-' . $next_type ) . '">';
            } else {
                echo '<a href="' . esc_url( add_query_arg( $page_key, $paged + 1 ) ) . '" class="' . esc_attr( $btn_class . ' yuki-next-btn yuki-next-btn-' . $next_type ) . '">';
            }
            echo '<span>';
            if ( $next_type === 'text' ) {
                esc_html_e( $options->get( $prefix . 'pagination_next_text', $settings ) );
            } else {
                IconsManager::print( $options->get( $prefix . 'pagination_next_icon', $settings ) );
            }
            echo '</span>';
            echo ( $disabled ? '</span>' : '</a>' );
        };
        echo '<nav ' . Utils::render_attribute_string( $pagination_attrs ) . '>';
        if ( 'prev-next' === $type ) {
            // Show previous button
            if ( $paged > 1 ) {
                $show_previous_button();
            } elseif ( $show_disabled_button ) {
                $show_previous_button( true );
            }
            // Show next button
            if ( $paged < $pages ) {
                $show_next_button();
            } elseif ( $show_disabled_button ) {
                $show_next_button( true );
            }
        } elseif ( 'numbered' === $type ) {
            $range = 2;
            $showitems = $range * 2 + 1;
            // Show previous button
            if ( $options->checked( $prefix . 'pagination_prev_next_button', $settings ) ) {
                if ( $paged > 1 ) {
                    $show_previous_button();
                } elseif ( $show_disabled_button ) {
                    $show_previous_button( true );
                }
            }
            // Show numeric buttons
            for ($i = 1; $i <= $pages; $i++) {
                if ( 1 !== $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems) ) {
                    if ( $paged === $i ) {
                        echo '<span class="' . esc_attr( $current_btn_class ) . '">' . $i . '</span>';
                    } else {
                        echo '<a class="' . esc_attr( $btn_class ) . '" href="' . esc_url( add_query_arg( $page_key, $i ) ) . '">' . $i . '</a>';
                    }
                }
            }
            // Show next button
            if ( $options->checked( $prefix . 'pagination_prev_next_button', $settings ) ) {
                if ( $paged < $pages ) {
                    $show_next_button();
                } elseif ( $show_disabled_button ) {
                    $show_next_button( true );
                }
            }
        } else {
            if ( yuki_fs()->is_not_paying() ) {
                echo '<p>';
                echo wp_kses_post( yuki_upsell_info( __( 'Upgrade to %sPro Version%s to enable this feature', 'yuki' ) ) );
                echo '</p>';
            }
        }
        echo '</nav>';
    }

}
if ( !function_exists( 'yuki_posts_pagination_css' ) ) {
    /**
     * Generate css for posts pagination
     *
     * @param $args
     *
     * @return array
     */
    function yuki_posts_pagination_css(  $args  ) {
        $args = wp_parse_args( $args, [
            'prefix'   => '',
            'options'  => null,
            'settings' => [],
        ] );
        $prefix = $args['prefix'];
        $options = $args['options'];
        $settings = $args['settings'];
        $options = $options ?? CZ::getFacadeRoot();
        $pagination_type = $options->get( $prefix . 'pagination_type', $settings );
        $pagination_css = [];
        if ( $pagination_type === 'numbered' || $pagination_type === 'prev-next' ) {
            $button_color = $options->get( $prefix . 'pagination_button_color', $settings );
            $pagination_css = array_merge( Css::border( $options->get( $prefix . 'pagination_button_border', $settings ), '--yuki-pagination-button-border' ), [
                '--yuki-pagination-button-radius' => $options->get( $prefix . 'pagination_button_radius', $settings ),
                '--yuki-pagination-initial-color' => $button_color['initial'],
                '--yuki-pagination-active-color'  => $button_color['active'],
                '--yuki-pagination-accent-color'  => $button_color['accent'],
            ] );
        }
        return array_merge( $pagination_css, Css::typography( $options->get( $prefix . 'pagination_typography', $settings ) ), [
            'justify-content' => $options->get( $prefix . 'pagination_alignment', $settings ),
        ] );
    }

}